/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.ftpserver;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import org.appwork.controlling.State;
import org.appwork.controlling.StateConflictException;
import org.appwork.controlling.StateMachine;
import org.appwork.controlling.StateMachineInterface;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.Regex;
import org.appwork.utils.net.ftpserver.FtpBadSequenceException;
import org.appwork.utils.net.ftpserver.FtpCommandNotImplementedException;
import org.appwork.utils.net.ftpserver.FtpCommandParameterException;
import org.appwork.utils.net.ftpserver.FtpCommandSyntaxException;
import org.appwork.utils.net.ftpserver.FtpConnectionState;
import org.appwork.utils.net.ftpserver.FtpException;
import org.appwork.utils.net.ftpserver.FtpFile;
import org.appwork.utils.net.ftpserver.FtpFileNotExistException;
import org.appwork.utils.net.ftpserver.FtpNotLoginException;
import org.appwork.utils.net.ftpserver.FtpServer;

public class FtpConnection
implements Runnable,
StateMachineInterface {
    private static final State IDLE = new State("IDLE");
    private static final State USER = new State("USER");
    private static final State PASS = new State("USER");
    private static final State LOGIN = new State("USER");
    private static final State LOGOUT = new State("LOGOUT");
    private static final State IDLEEND = new State("IDLEEND");
    private final FtpServer ftpServer;
    private final Socket controlSocket;
    private BufferedReader reader;
    private BufferedWriter writer;
    private StateMachine stateMachine = null;
    private Thread thread = null;
    private String passiveIP = null;
    private int passivePort = 0;
    private TYPE type = TYPE.BINARY;
    private final FtpConnectionState connectionState;
    private Socket dataSocket = null;
    private ServerSocket serverSocket = null;

    public FtpConnection(FtpServer ftpServer, Socket clientSocket) throws IOException {
        this.stateMachine = new StateMachine(this, IDLE, IDLEEND);
        this.connectionState = ftpServer.getFtpCommandHandler().createNewConnectionState();
        this.ftpServer = ftpServer;
        this.controlSocket = clientSocket;
        this.controlSocket.setSoTimeout(20000);
        try {
            this.reader = new BufferedReader(new InputStreamReader(this.controlSocket.getInputStream()));
            this.writer = new BufferedWriter(new OutputStreamWriter(this.controlSocket.getOutputStream()));
            this.thread = new Thread(ftpServer.getThreadGroup(), this){

                @Override
                public void interrupt() {
                    FtpConnection.this.closeDataConnection();
                    try {
                        FtpConnection.this.controlSocket.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    super.interrupt();
                }
            };
            this.thread.setName("FTPConnectionThread: " + this);
            this.thread.start();
        }
        catch (IOException e) {
            try {
                this.controlSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.closeDataConnection();
            throw e;
        }
    }

    private String buildParameter(String[] commandParts) {
        if (commandParts == null) {
            return null;
        }
        String param = "";
        for (int index = 1; index < commandParts.length; ++index) {
            if (param.length() > 0) {
                param = param + " ";
            }
            param = param + commandParts[index];
        }
        return param;
    }

    private void closeDataConnection() {
        try {
            this.dataSocket.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.dataSocket = null;
        }
        try {
            this.serverSocket.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.serverSocket = null;
        }
    }

    @Override
    public StateMachine getStateMachine() {
        return this.stateMachine;
    }

    private void handleCommand(String command) throws IOException {
        block42: {
            try {
                String[] commandParts = command.split(" ");
                COMMAND commandEnum = null;
                try {
                    commandEnum = COMMAND.valueOf(commandParts[0]);
                }
                catch (IllegalArgumentException e) {
                    commandEnum = null;
                }
                try {
                    if (commandEnum != null) {
                        if (commandEnum.needLogin && !this.stateMachine.isState(LOGIN)) {
                            throw new FtpNotLoginException();
                        }
                        if (!commandEnum.match(commandParts.length - 1)) {
                            throw new FtpCommandSyntaxException();
                        }
                        if (this.connectionState.getRenameFile() != null && !commandEnum.equals((Object)COMMAND.RNTO)) {
                            this.connectionState.setRenameFile(null);
                            throw new FtpBadSequenceException();
                        }
                        switch (commandEnum) {
                            case ABOR: {
                                this.onABOR();
                                break;
                            }
                            case REST: {
                                this.onREST(commandParts);
                                break;
                            }
                            case PASV: {
                                this.onPASV();
                                break;
                            }
                            case RNTO: {
                                this.onRNTO(commandParts);
                                break;
                            }
                            case RNFR: {
                                this.onRNFR(commandParts);
                                break;
                            }
                            case XRMD: 
                            case RMD: {
                                this.onRMD(commandParts);
                                break;
                            }
                            case DELE: {
                                this.onDELE(commandParts);
                                break;
                            }
                            case SIZE: {
                                this.onSIZE(commandParts);
                                break;
                            }
                            case STRU: {
                                this.onSTRU(commandParts);
                                break;
                            }
                            case MODE: {
                                this.onMODE(commandParts);
                                break;
                            }
                            case ALLO: {
                                this.onALLO();
                                break;
                            }
                            case APPE: {
                                this.onSTOR(commandParts, true);
                                break;
                            }
                            case STOR: {
                                this.onSTOR(commandParts, false);
                                break;
                            }
                            case XMKD: 
                            case MKD: {
                                this.onMKD(commandParts);
                                break;
                            }
                            case NLST: {
                                this.onNLST(commandParts);
                                break;
                            }
                            case EPSV: {
                                this.onEPSV(commandParts);
                                break;
                            }
                            case EPRT: {
                                this.onEPRT(commandParts);
                                break;
                            }
                            case RETR: {
                                this.onRETR(commandParts);
                                break;
                            }
                            case LIST: {
                                this.onLIST(commandParts);
                                break;
                            }
                            case USER: {
                                this.onUSER(commandParts);
                                break;
                            }
                            case PORT: {
                                this.onPORT(commandParts);
                                break;
                            }
                            case SYST: {
                                this.onSYST();
                                break;
                            }
                            case QUIT: {
                                this.onQUIT();
                                break;
                            }
                            case PASS: {
                                this.onPASS(commandParts);
                                break;
                            }
                            case NOOP: {
                                this.onNOOP();
                                break;
                            }
                            case XPWD: 
                            case PWD: {
                                this.onPWD();
                                break;
                            }
                            case XCWD: 
                            case CWD: {
                                this.onCWD(commandParts);
                                break;
                            }
                            case XCUP: 
                            case CDUP: {
                                this.onCDUP();
                                break;
                            }
                            case TYPE: {
                                this.onTYPE(commandParts);
                            }
                        }
                        break block42;
                    }
                    throw new FtpCommandNotImplementedException();
                }
                catch (StateConflictException e) {
                    throw new FtpBadSequenceException();
                }
            }
            catch (FtpException e) {
                this.write(e.getCode(), e.getMessage());
            }
            catch (Throwable e) {
                this.write(550, e.getMessage());
            }
        }
    }

    private void onABOR() throws IOException {
        this.write(226, "Command okay");
    }

    private void onALLO() throws IOException {
        this.write(200, "Command okay");
    }

    private void onCDUP() throws IOException, FtpException {
        this.ftpServer.getFtpCommandHandler().onDirectoryUp(this.connectionState);
        this.write(200, "Command okay.");
    }

    private void onCWD(String[] params) throws IOException, FtpException {
        this.ftpServer.getFtpCommandHandler().setCurrentDirectory(this.connectionState, this.buildParameter(params));
        this.write(250, "Directory successfully changed.");
    }

    private void onDELE(String[] commandParts) throws FtpFileNotExistException, FtpException, IOException {
        this.ftpServer.getFtpCommandHandler().removeFile(this.connectionState, this.buildParameter(commandParts));
        this.write(250, "\"" + this.buildParameter(commandParts) + "\" removed.");
    }

    private void onEPRT(String[] commandParts) throws IOException, FtpException {
        String[] parts = commandParts[1].split("\\|");
        this.closeDataConnection();
        if (parts.length != 4) {
            throw new FtpCommandSyntaxException();
        }
        if (!"1".equals(parts[1])) {
            throw new FtpException(522, "Network protocol not supported, use (1)");
        }
        this.passiveIP = parts[2];
        this.passivePort = Integer.parseInt(parts[3]);
        this.write(200, "PORT command successful");
    }

    private void onEPSV(String[] commandParts) throws FtpException {
        boolean okay = false;
        this.closeDataConnection();
        try {
            this.serverSocket = new ServerSocket();
            InetSocketAddress socketAddress = null;
            if (this.ftpServer.isLocalhostOnly()) {
                socketAddress = new InetSocketAddress(this.ftpServer.getLocalHost(), 0);
            }
            this.serverSocket.bind(socketAddress);
            okay = true;
            int port = this.serverSocket.getLocalPort();
            this.write(229, "Entering Extended Passive Mode (|||" + port + "|)");
            return;
        }
        catch (IOException e) {
            throw new FtpException(421, "could not open port");
        }
        finally {
            if (!okay) {
                this.closeDataConnection();
            }
        }
    }

    private void onLIST(String[] params) throws IOException, FtpException {
        try {
            try {
                this.openDataConnection();
            }
            catch (IOException e) {
                throw new FtpException(425, "Can't open data connection");
            }
            this.write(150, "Opening XY mode data connection for file list");
            try {
                List<? extends FtpFile> list = this.ftpServer.getFtpCommandHandler().getFileList(this.connectionState, this.buildParameter(params));
                this.dataSocket.getOutputStream().write(this.ftpServer.getFtpCommandHandler().formatFileList(list).getBytes("UTF-8"));
                this.dataSocket.getOutputStream().flush();
            }
            catch (FtpFileNotExistException e) {
                throw new FtpException(450, "Requested file action not taken; File unavailable");
            }
            catch (FtpException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FtpException(451, "Requested action aborted: local error in processing");
            }
            this.write(226, "Transfer complete.");
        }
        finally {
            this.closeDataConnection();
        }
    }

    private void onMKD(String[] commandParts) throws IOException, FtpException {
        this.ftpServer.getFtpCommandHandler().makeDirectory(this.connectionState, this.buildParameter(commandParts));
        this.write(257, "\"" + this.buildParameter(commandParts) + "\" created.");
    }

    private void onMODE(String[] commandParts) throws IOException, FtpCommandParameterException {
        if (!"S".equalsIgnoreCase(commandParts[1])) {
            throw new FtpCommandParameterException();
        }
        this.write(200, "Command okay.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNLST(String[] commandParts) throws IOException, FtpException {
        try {
            try {
                this.openDataConnection();
            }
            catch (IOException e) {
                throw new FtpException(425, "Can't open data connection");
            }
            this.write(150, "Opening XY mode data connection for file list");
            try {
                List<? extends FtpFile> list = this.ftpServer.getFtpCommandHandler().getFileList(this.connectionState, this.buildParameter(commandParts));
                StringBuilder sb = new StringBuilder();
                for (FtpFile ftpFile : list) {
                    sb.append(ftpFile.getName());
                    sb.append("\r\n");
                }
                this.dataSocket.getOutputStream().write(sb.toString().getBytes("UTF-8"));
                this.dataSocket.getOutputStream().flush();
            }
            catch (FtpFileNotExistException e) {
                throw new FtpException(450, "Requested file action not taken; File unavailable");
            }
            catch (FtpException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FtpException(451, "Requested action aborted: local error in processing");
            }
            this.write(226, "Transfer complete.");
        }
        finally {
            this.closeDataConnection();
        }
    }

    private void onNOOP() throws IOException {
        this.write(200, "Command okay");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onPASS(String[] params) throws IOException, FtpException {
        this.stateMachine.setStatus(PASS);
        if (this.connectionState.getUser() == null) {
            throw new FtpBadSequenceException();
        }
        if (this.connectionState.getUser().getPassword() == null) throw new RuntimeException("THIS MUST NOT HAPPEN!");
        if (this.connectionState.getUser().getPassword().equals(params[1])) {
            String message = this.ftpServer.getFtpCommandHandler().onLoginSuccessRequest(this.connectionState);
            if (message != null) {
                this.write(230, message, true);
            }
        } else {
            String message = this.ftpServer.getFtpCommandHandler().onLoginFailedMessage(this.connectionState);
            if (message != null) {
                this.write(530, message, true);
            }
            this.stateMachine.setStatus(LOGOUT);
            this.stateMachine.setStatus(IDLEEND);
            this.stateMachine.reset(false);
            throw new FtpNotLoginException();
        }
        this.write(230, "User logged in, proceed");
        this.stateMachine.setStatus(LOGIN);
    }

    private void onPASV() throws FtpException {
        boolean okay = false;
        this.closeDataConnection();
        try {
            this.serverSocket = new ServerSocket();
            InetSocketAddress socketAddress = null;
            if (this.ftpServer.isLocalhostOnly()) {
                socketAddress = new InetSocketAddress(this.ftpServer.getLocalHost(), 0);
            }
            this.serverSocket.bind(socketAddress);
            okay = true;
            int port = this.serverSocket.getLocalPort();
            int p1 = port / 256;
            int p2 = port - p1 * 256;
            if (this.ftpServer.isLocalhostOnly()) {
                this.write(227, "Entering Passive Mode. (127,0,0,1," + p1 + "," + p2 + ").");
            } else if (this.controlSocket.getLocalAddress().isLoopbackAddress()) {
                this.write(227, "Entering Passive Mode. (127,0,0,1," + p1 + "," + p2 + ").");
            } else {
                String ip = this.controlSocket.getLocalAddress().getHostAddress();
                ip = ip.replaceAll("\\.", ",");
                this.write(227, "Entering Passive Mode. (" + ip + "," + p1 + "," + p2 + ").");
            }
            return;
        }
        catch (IOException e) {
            throw new FtpException(421, "could not open port");
        }
        finally {
            if (!okay) {
                this.closeDataConnection();
            }
        }
    }

    private void onPORT(String[] params) throws IOException, FtpCommandSyntaxException {
        try {
            this.dataSocket.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.dataSocket = null;
        }
        String[] parts = params[1].split(",");
        if (parts.length != 6) {
            throw new FtpCommandSyntaxException();
        }
        this.passiveIP = parts[0] + "." + parts[1] + "." + parts[2] + "." + parts[3];
        this.passivePort = Integer.parseInt(parts[4]) * 256 + Integer.parseInt(parts[5]);
        this.write(200, "PORT command successful");
    }

    private void onPWD() throws IOException, FtpException {
        this.write(257, "\"" + this.connectionState.getCurrentDir() + "\" is cwd.");
    }

    private void onQUIT() throws IOException, FtpException {
        this.stateMachine.setStatus(LOGOUT);
        this.write(221, this.ftpServer.getFtpCommandHandler().onLogoutRequest(this.connectionState));
        this.stateMachine.setStatus(IDLEEND);
    }

    private void onREST(String[] commandParts) throws FtpException, IOException {
        try {
            long position = Long.parseLong(commandParts[1]);
            this.ftpServer.getFtpCommandHandler().onREST(this.connectionState, position);
            this.write(350, "Restarting at " + position + ". Send STORE or RETRIEVE");
        }
        catch (NumberFormatException e) {
            this.write(554, "Requested action not taken: invalid REST parameter.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRETR(String[] commandParts) throws IOException, FtpException {
        try {
            try {
                this.openDataConnection();
            }
            catch (IOException e) {
                throw new FtpException(425, "Can't open data connection");
            }
            this.ftpServer.getFtpCommandHandler().getSize(this.connectionState, this.buildParameter(commandParts));
            this.write(150, "Opening XY mode data connection for transfer");
            long bytesWritten = 0L;
            try {
                bytesWritten = this.ftpServer.getFtpCommandHandler().onRETR(this.dataSocket.getOutputStream(), this.connectionState, this.buildParameter(commandParts));
                this.dataSocket.getOutputStream().flush();
                this.dataSocket.shutdownOutput();
            }
            catch (FtpFileNotExistException e) {
                throw new FtpException(450, "Requested file action not taken; File unavailable");
            }
            catch (FtpException e) {
                throw e;
            }
            catch (IOException e) {
                throw new FtpException(426, e.getMessage());
            }
            catch (Exception e) {
                throw new FtpException(451, e.getMessage());
            }
            this.write(226, "Transfer complete. " + bytesWritten + " bytes transfered!");
        }
        finally {
            this.closeDataConnection();
        }
    }

    private void onRMD(String[] commandParts) throws IOException, FtpException {
        this.ftpServer.getFtpCommandHandler().removeDirectory(this.connectionState, this.buildParameter(commandParts));
        this.write(250, "\"" + this.buildParameter(commandParts) + "\" removed.");
    }

    private void onRNFR(String[] commandParts) throws FtpException, IOException {
        if (this.connectionState.getRenameFile() != null) {
            this.connectionState.setRenameFile(null);
            throw new FtpBadSequenceException();
        }
        try {
            this.ftpServer.getFtpCommandHandler().renameFile(this.connectionState, this.buildParameter(commandParts));
        }
        catch (FtpException e) {
            this.connectionState.setRenameFile(null);
            throw e;
        }
        this.write(350, "\"" + this.buildParameter(commandParts) + "\" rename pending.");
    }

    private void onRNTO(String[] commandParts) throws IOException, FtpException {
        if (this.connectionState.getRenameFile() == null) {
            this.connectionState.setRenameFile(null);
            throw new FtpBadSequenceException();
        }
        try {
            this.ftpServer.getFtpCommandHandler().renameFile(this.connectionState, this.buildParameter(commandParts));
        }
        finally {
            this.connectionState.setRenameFile(null);
        }
        this.write(250, "\"" + this.buildParameter(commandParts) + "\" rename successful.");
    }

    private void onSIZE(String[] commandParts) throws FtpException, IOException {
        this.write(213, "" + this.ftpServer.getFtpCommandHandler().getSize(this.connectionState, this.buildParameter(commandParts)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSTOR(String[] commandParts, boolean append) throws IOException, FtpException {
        try {
            try {
                this.openDataConnection();
            }
            catch (IOException e) {
                throw new FtpException(425, "Can't open data connection");
            }
            this.write(150, "Opening XY mode data connection for transfer");
            long bytesRead = 0L;
            try {
                bytesRead = this.ftpServer.getFtpCommandHandler().onSTOR(this.dataSocket.getInputStream(), this.connectionState, append, this.buildParameter(commandParts));
                this.dataSocket.shutdownInput();
            }
            catch (FtpFileNotExistException e) {
                throw new FtpException(450, "Requested file action not taken; File unavailable");
            }
            catch (FtpException e) {
                throw e;
            }
            catch (IOException e) {
                throw new FtpException(426, e.getMessage());
            }
            catch (Exception e) {
                throw new FtpException(451, e.getMessage());
            }
            this.write(226, "Transfer complete. " + bytesRead + " bytes received!");
        }
        finally {
            this.closeDataConnection();
        }
    }

    private void onSTRU(String[] commandParts) throws IOException, FtpCommandParameterException {
        if (!"F".equalsIgnoreCase(commandParts[1])) {
            throw new FtpCommandParameterException();
        }
        this.write(200, "Command okay.");
    }

    private void onSYST() throws IOException {
        this.write(215, "UNIX Type: L8");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onTYPE(String[] commandParts) throws IOException, FtpCommandParameterException {
        String type = commandParts[1];
        if ("A".equalsIgnoreCase(type)) {
            this.type = TYPE.ASCII;
        } else if ("I".equalsIgnoreCase(type)) {
            this.type = TYPE.BINARY;
        } else {
            if (!"L".equalsIgnoreCase(type)) throw new FtpCommandParameterException();
            if (commandParts.length != 3 || !"8".equals(commandParts[2])) throw new FtpCommandParameterException();
            this.type = TYPE.BINARY;
        }
        this.write(200, "Command okay");
    }

    private void onUSER(String[] params) throws IOException, FtpException {
        if (this.stateMachine.isFinal()) {
            this.stateMachine.reset(false);
        }
        this.stateMachine.setStatus(USER);
        this.connectionState.setUser(this.ftpServer.getFtpCommandHandler().getUser(params[1]));
        if (this.connectionState.getUser() != null) {
            if (this.connectionState.getUser().getPassword() == null) {
                String message = this.ftpServer.getFtpCommandHandler().onLoginSuccessRequest(this.connectionState);
                if (message != null) {
                    this.write(230, message, true);
                }
                this.write(230, "User logged in, proceed");
                this.stateMachine.setStatus(LOGIN);
            } else {
                this.write(331, "User name okay, need password");
            }
        } else {
            String message = this.ftpServer.getFtpCommandHandler().onLoginFailedMessage(this.connectionState);
            if (message != null) {
                this.write(530, message, true);
            }
            this.stateMachine.setStatus(LOGOUT);
            this.stateMachine.setStatus(IDLEEND);
            this.stateMachine.reset(false);
            throw new FtpNotLoginException();
        }
    }

    private void openDataConnection() throws IOException {
        if (this.dataSocket == null || !this.dataSocket.isConnected()) {
            this.dataSocket = this.serverSocket != null && this.serverSocket.isBound() ? this.serverSocket.accept() : new Socket(this.passiveIP, this.passivePort);
        }
    }

    @Override
    public void run() {
        try {
            String command;
            this.writeMultiLineAuto(220, this.ftpServer.getFtpCommandHandler().getWelcomeMessage(this.connectionState));
            while ((command = this.reader.readLine()) != null) {
                if (this.ftpServer.isDebug()) {
                    LogV3.info("REQ: " + command);
                }
                this.handleCommand(command);
            }
        }
        catch (IOException e) {
            try {
                this.onQUIT();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (FtpException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            this.closeDataConnection();
            try {
                this.controlSocket.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void write(int code, String message) throws IOException {
        if (this.ftpServer.isDebug()) {
            LogV3.info("RESP: " + code + " " + message);
        }
        this.write(code, message, false);
    }

    private void write(int code, String message, boolean multiLine) throws IOException {
        if (multiLine) {
            this.writer.write(code + "-" + message + "\r\n");
        } else {
            this.writer.write(code + " " + message + "\r\n");
        }
        this.writer.flush();
    }

    private void writeMultiLineAuto(int code, String message) throws IOException {
        String[] lines = Regex.getLines(message);
        if (lines != null) {
            for (int line = 0; line < lines.length; ++line) {
                if (line == lines.length - 1) {
                    this.writer.write(code + " " + lines[line] + "\r\n");
                    continue;
                }
                this.writer.write(code + "-" + lines[line] + "\r\n");
            }
        }
        this.writer.flush();
    }

    static {
        IDLE.addChildren(USER);
        USER.addChildren(PASS, LOGIN, LOGOUT);
        PASS.addChildren(LOGIN, LOGOUT);
        LOGIN.addChildren(LOGOUT);
        LOGOUT.addChildren(IDLEEND);
    }

    private static enum TYPE {
        ASCII,
        BINARY;

    }

    public static enum COMMAND {
        ABOR(true, 0),
        REST(true, 1),
        RNTO(true, 1, -1),
        RNFR(true, 1, -1),
        DELE(true, 1, -1),
        XRMD(true, 1, -1),
        RMD(true, 1, -1),
        SIZE(true, 1, -1),
        STRU(true, 1),
        MODE(true, 1),
        ALLO(true, 1, -1),
        APPE(true, 1, -1),
        STOR(true, 1, -1),
        XMKD(true, 1, -1),
        MKD(true, 1, -1),
        NLST(true, 1, -1),
        EPRT(true, 1, 1),
        EPSV(true, 0),
        RETR(true, 1, -1),
        TYPE(true, 1, 2),
        LIST(true, 0, 1),
        XCUP(true, 0),
        CDUP(true, 0),
        XCWD(true, 1, -1),
        CWD(true, 1, -1),
        XPWD(true, 0),
        PWD(true, 0),
        NOOP(false, 0),
        PASV(true, 0),
        PASS(false, 1),
        QUIT(true, 0),
        SYST(true, 0),
        PORT(true, 1),
        USER(false, 1);

        private int paramSize;
        private int maxSize;
        private boolean needLogin;

        private COMMAND(boolean needLogin, int paramSize) {
            this(needLogin, paramSize, paramSize);
        }

        private COMMAND(boolean needLogin, int paramSize, int maxSize) {
            this.paramSize = paramSize;
            this.needLogin = needLogin;
            this.maxSize = maxSize;
        }

        public boolean match(int length) {
            if (length == this.paramSize) {
                return true;
            }
            if (length == this.maxSize) {
                return true;
            }
            return this.maxSize == -1;
        }

        public boolean needsLogin() {
            return this.needLogin;
        }
    }
}

