/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SkippingLimitedOutputStream
extends FilterOutputStream {
    private final long skip;
    private final long limit;
    protected long position = 0L;

    public SkippingLimitedOutputStream(OutputStream out, long skip) {
        this(out, skip, -1L);
    }

    public SkippingLimitedOutputStream(OutputStream out, long skip, long limit) {
        super(out);
        this.skip = Math.max(0L, skip);
        this.limit = limit < 0L ? -1L : Math.max(this.skip, limit);
    }

    public long getSkipLeft() {
        return Math.max(0L, this.skip - this.position);
    }

    public boolean isSkipping() {
        return this.position < this.skip;
    }

    public long getLimitLeft() {
        if (this.limit == -1L) {
            return Long.MAX_VALUE;
        }
        return Math.max(0L, this.limit - this.position);
    }

    public boolean isLimitReached() {
        return this.limit != -1L && this.position >= this.limit;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] array = new byte[]{(byte)b};
        this.write(array, 0, 1);
    }

    public void simulateWrite(long len) throws IOException {
        this.position += Math.max(0L, len);
    }

    protected int writeSkip(byte[] b, int off, int len) throws IOException {
        long skipLeft = this.getSkipLeft();
        if (skipLeft > 0L) {
            if (skipLeft >= (long)len) {
                this.simulateWrite(len);
                return len;
            }
            int skip = (int)skipLeft;
            this.simulateWrite(skip);
            return skip;
        }
        return 0;
    }

    protected int writeUnlimited(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.position += (long)len;
        return len;
    }

    protected int writeLimited(byte[] b, int off, int len) throws IOException {
        long limitLeft = this.getLimitLeft();
        if (limitLeft > 0L) {
            if (limitLeft >= (long)len) {
                return this.writeUnlimited(b, off, len);
            }
            return this.writeUnlimited(b, off, (int)limitLeft);
        }
        return 0;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int skipped;
        if (len > 0 && (skipped = this.writeSkip(b, off, len)) != len) {
            this.writeLimited(b, skipped, len - skipped);
        }
    }
}

