/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.locale.Loc;
import org.appwork.utils.net.DownloadProgress;
import org.appwork.utils.net.HTTPException;

public class SimpleHTTP {
    private static final Object CALL_LOCK = new Object();
    private final HashMap<String, String> requestHeader = new HashMap();
    private HttpURLConnection connection;
    private int connectTimeout = 15000;
    private int readTimeout = 30000;
    private boolean followRedirects = true;
    private boolean headerDebug = false;

    public void clearRequestHeader() {
        this.requestHeader.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(URL url, DownloadProgress progress, File file) throws IOException, InterruptedException {
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            try {
                this.download(url, progress, 0L, out);
            }
            catch (IOException e) {
                try {
                    out.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (file.length() > 0L) {
                    HTTPException ex = new HTTPException(this.connection, IO.readFileToString(file), e);
                    file.delete();
                    throw ex;
                }
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public byte[] download(URL url, DownloadProgress progress, long maxSize) throws IOException, InterruptedException {
        ByteArrayOutputStream baos;
        block4: {
            baos = new ByteArrayOutputStream();
            try {
                this.download(url, progress, maxSize, baos);
            }
            catch (IOException e) {
                if (baos.size() <= 0) break block4;
                throw new HTTPException(this.connection, new String(baos.toByteArray(), this.getCharset()), e);
            }
        }
        try {
            baos.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(URL url, DownloadProgress progress, long maxSize, OutputStream baos) throws IOException, InterruptedException {
        BufferedInputStream input = null;
        GZIPInputStream gzi = null;
        try {
            int len;
            this.connection = (HttpURLConnection)url.openConnection();
            this.connection.setInstanceFollowRedirects(this.followRedirects);
            this.connection.setConnectTimeout(this.connectTimeout);
            this.connection.setReadTimeout(this.readTimeout);
            try {
                String loc = Loc.getLocale().split("_")[0];
                this.connection.setRequestProperty("Accept-Language", loc);
            }
            catch (Throwable loc) {
                // empty catch block
            }
            this.connection.setRequestProperty("User-Agent", "AppWork " + Application.getApplication());
            this.connection.setRequestProperty("Connection", "Close");
            for (Map.Entry entry : this.requestHeader.entrySet()) {
                this.connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            this.connection.connect();
            IOException exception = null;
            try {
                if (this.connection.getHeaderField("Content-Encoding") != null && this.connection.getHeaderField("Content-Encoding").equalsIgnoreCase("gzip")) {
                    gzi = new GZIPInputStream(this.connection.getInputStream());
                    input = new BufferedInputStream(gzi);
                } else {
                    input = new BufferedInputStream(this.connection.getInputStream());
                }
            }
            catch (IOException iOException) {
                exception = iOException;
                if (this.connection.getHeaderField("Content-Encoding") != null && this.connection.getHeaderField("Content-Encoding").equalsIgnoreCase("gzip")) {
                    gzi = new GZIPInputStream(this.connection.getErrorStream());
                    input = new BufferedInputStream(gzi);
                }
                input = new BufferedInputStream(this.connection.getErrorStream());
            }
            if (maxSize > 0L && (long)this.connection.getContentLength() > maxSize) {
                throw new IOException("Max size exeeded!");
            }
            if (progress != null) {
                progress.setTotal(this.connection.getContentLength());
            }
            byte[] byArray = new byte[Short.MAX_VALUE];
            long loaded = 0L;
            while ((len = input.read(byArray)) != -1) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                if (len > 0) {
                    baos.write(byArray, 0, len);
                    if (maxSize > 0L && (loaded += (long)len) > maxSize) {
                        throw new IOException("Max size exeeded!");
                    }
                }
                if (progress == null) continue;
                progress.increaseLoaded(len);
            }
            if (exception != null) {
                throw exception;
            }
        }
        finally {
            try {
                input.close();
            }
            catch (Exception exception) {}
            try {
                gzi.close();
            }
            catch (Exception exception) {}
            try {
                this.connection.disconnect();
            }
            catch (Throwable throwable) {}
        }
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPage(URL url) throws IOException, InterruptedException {
        Object object = CALL_LOCK;
        synchronized (object) {
            String string;
            BufferedReader in = null;
            InputStreamReader isr = null;
            StringBuilder sb = new StringBuilder();
            try {
                String string2;
                this.connection = (HttpURLConnection)url.openConnection();
                this.connection.setInstanceFollowRedirects(this.followRedirects);
                this.connection.setConnectTimeout(this.connectTimeout);
                this.connection.setReadTimeout(this.readTimeout);
                try {
                    String loc = Loc.getLocale().split("_")[0];
                    this.connection.setRequestProperty("Accept-Language", loc);
                }
                catch (Throwable loc) {
                    // empty catch block
                }
                this.connection.setRequestProperty("User-Agent", "AppWork " + Application.getApplication());
                this.connection.setRequestProperty("Connection", "Close");
                this.connection.setRequestProperty("Accept-Charset", this.getCharset());
                for (Map.Entry entry : this.requestHeader.entrySet()) {
                    this.connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
                if (this.headerDebug) {
                    for (Map.Entry<String, List<String>> entry : this.connection.getRequestProperties().entrySet()) {
                        for (String value : entry.getValue()) {
                            if (sb.length() > 0) {
                                sb.append("\r\n");
                            }
                            sb.append("REQUEST: " + entry.getKey() + " = " + value);
                        }
                    }
                }
                int lookupTry = 0;
                while (true) {
                    try {
                        this.connection.connect();
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (++lookupTry > 3) {
                            throw unknownHostException;
                        }
                        Thread.sleep(200L);
                        continue;
                    }
                    break;
                }
                isr = new InputStreamReader(this.connection.getInputStream(), this.getCharset());
                in = new BufferedReader(isr);
                StringBuilder sb2 = new StringBuilder();
                while ((string2 = in.readLine()) != null) {
                    if (sb2.length() > 0) {
                        sb2.append("\r\n");
                    }
                    sb2.append(string2);
                }
                if (this.headerDebug) {
                    for (Map.Entry<String, List<String>> next : this.connection.getHeaderFields().entrySet()) {
                        for (String value : next.getValue()) {
                            if (sb.length() > 0) {
                                sb.append("\r\n");
                            }
                            sb.append("RESPONSE: " + next.getKey() + " = " + value);
                        }
                    }
                    LogV3.info(sb.toString());
                }
                string = sb2.toString();
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    isr.close();
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                try {
                    this.connection.disconnect();
                }
                catch (Throwable throwable4) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                isr.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.connection.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return string;
        }
    }

    protected String getCharset() {
        return "UTF-8";
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public HashMap<String, String> getRequestHeader() {
        return this.requestHeader;
    }

    public String getRequestHeader(String key) {
        return this.requestHeader.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponseHeader(String string) {
        Object object = CALL_LOCK;
        synchronized (object) {
            if (this.connection == null) {
                return null;
            }
            return this.connection.getHeaderField(string);
        }
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public boolean isHeaderDebug() {
        return this.headerDebug;
    }

    public HttpURLConnection openGetConnection(URL url) throws IOException, InterruptedException {
        return this.openGetConnection(url, this.readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpURLConnection openGetConnection(URL url, int readTimeout) throws IOException, InterruptedException {
        boolean close = true;
        Object object = CALL_LOCK;
        synchronized (object) {
            HttpURLConnection httpURLConnection;
            StringBuilder sb = new StringBuilder();
            try {
                this.connection = (HttpURLConnection)url.openConnection();
                this.connection.setConnectTimeout(this.connectTimeout);
                this.connection.setInstanceFollowRedirects(this.followRedirects);
                this.connection.setReadTimeout(readTimeout < 0 ? readTimeout : readTimeout);
                try {
                    String loc = Loc.getLocale().split("_")[0];
                    this.connection.setRequestProperty("Accept-Language", loc);
                }
                catch (Throwable loc) {
                    // empty catch block
                }
                this.connection.setRequestProperty("User-Agent", "AppWork " + Application.getApplication());
                this.connection.setRequestProperty("Connection", "Close");
                this.connection.setRequestProperty("Accept-Charset", this.getCharset());
                for (Map.Entry httpURLConnection2 : this.requestHeader.entrySet()) {
                    this.connection.setRequestProperty((String)httpURLConnection2.getKey(), (String)httpURLConnection2.getValue());
                }
                if (this.headerDebug) {
                    for (Map.Entry<String, List<String>> entry : this.connection.getRequestProperties().entrySet()) {
                        for (String value : entry.getValue()) {
                            if (sb.length() > 0) {
                                sb.append("\r\n");
                            }
                            sb.append("REQUEST: " + entry.getKey() + " = " + value);
                        }
                    }
                }
                int lookupTry = 0;
                while (true) {
                    try {
                        this.connection.connect();
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (++lookupTry > 3) {
                            throw unknownHostException;
                        }
                        Thread.sleep(200L);
                        continue;
                    }
                    break;
                }
                close = false;
                if (this.headerDebug) {
                    for (Map.Entry<String, List<String>> next : this.connection.getHeaderFields().entrySet()) {
                        for (String value : next.getValue()) {
                            if (sb.length() > 0) {
                                sb.append("\r\n");
                            }
                            sb.append("RESPONSE: " + next.getKey() + " = " + value);
                        }
                    }
                    LogV3.info(sb.toString());
                }
                httpURLConnection = this.connection;
            }
            catch (Throwable throwable) {
                try {
                    if (close) {
                        this.connection.disconnect();
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (close) {
                    this.connection.disconnect();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return httpURLConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpURLConnection openPostConnection(URL url, String postData, HashMap<String, String> header) throws IOException, InterruptedException {
        boolean close = true;
        Object object = CALL_LOCK;
        synchronized (object) {
            HttpURLConnection httpURLConnection;
            OutputStreamWriter writer = null;
            OutputStream outputStream = null;
            StringBuilder sb = new StringBuilder();
            try {
                this.connection = (HttpURLConnection)url.openConnection();
                this.connection.setInstanceFollowRedirects(this.followRedirects);
                this.connection.setConnectTimeout(this.connectTimeout);
                this.connection.setReadTimeout(this.readTimeout);
                this.connection.setRequestMethod("POST");
                this.connection.setDoInput(true);
                this.connection.setUseCaches(false);
                this.connection.setDoOutput(true);
                if (Loc.getLocale() != null) {
                    try {
                        String loc = Loc.getLocale().split("_")[0];
                        this.connection.setRequestProperty("Accept-Language", loc);
                    }
                    catch (Throwable e) {
                        LogV3.log(e);
                    }
                }
                this.connection.setRequestProperty("User-Agent", "AppWork " + Application.getApplication());
                this.connection.setRequestProperty("Connection", "Close");
                if (header != null) {
                    for (Map.Entry<String, String> httpURLConnection2 : header.entrySet()) {
                        this.connection.setRequestProperty(httpURLConnection2.getKey(), httpURLConnection2.getValue());
                    }
                }
                for (Map.Entry<String, String> entry : this.requestHeader.entrySet()) {
                    this.connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
                if (this.headerDebug) {
                    for (Map.Entry<String, List<String>> entry : this.connection.getRequestProperties().entrySet()) {
                        for (String value : entry.getValue()) {
                            if (sb.length() > 0) {
                                sb.append("\r\n");
                            }
                            sb.append("REQUEST: " + entry.getKey() + " = " + value);
                        }
                    }
                }
                int lookupTry = 0;
                while (true) {
                    try {
                        this.connection.connect();
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (++lookupTry > 3) {
                            throw unknownHostException;
                        }
                        Thread.sleep(200L);
                        continue;
                    }
                    break;
                }
                outputStream = this.connection.getOutputStream();
                writer = new OutputStreamWriter(outputStream);
                writer.write(postData);
                writer.flush();
                close = false;
                if (this.headerDebug) {
                    for (Map.Entry<String, List<String>> next : this.connection.getHeaderFields().entrySet()) {
                        for (String value : next.getValue()) {
                            if (sb.length() > 0) {
                                sb.append("\r\n");
                            }
                            sb.append("RESPONSE: " + next.getKey() + " = " + value);
                        }
                    }
                    LogV3.info(sb.toString());
                }
                httpURLConnection = this.connection;
            }
            catch (Throwable throwable) {
                try {
                    if (close) {
                        this.connection.disconnect();
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    writer.close();
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                try {
                    outputStream.close();
                }
                catch (Throwable throwable4) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (close) {
                    this.connection.disconnect();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                writer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return httpURLConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postPage(URL url, String data) throws IOException, InterruptedException {
        Object object = CALL_LOCK;
        synchronized (object) {
            String string;
            OutputStreamWriter writer = null;
            BufferedReader reader = null;
            OutputStream outputStream = null;
            InputStreamReader isr = null;
            try {
                String str;
                this.connection = (HttpURLConnection)url.openConnection();
                this.connection.setInstanceFollowRedirects(this.followRedirects);
                this.connection.setConnectTimeout(this.connectTimeout);
                this.connection.setReadTimeout(this.readTimeout);
                this.connection.setRequestMethod("POST");
                this.connection.setDoInput(true);
                this.connection.setUseCaches(false);
                this.connection.setDoOutput(true);
                try {
                    String loc = Loc.getLocale().split("_")[0];
                    this.connection.setRequestProperty("Accept-Language", loc);
                }
                catch (Throwable loc) {
                    // empty catch block
                }
                this.connection.setRequestProperty("User-Agent", "AppWork " + Application.getApplication());
                this.connection.setRequestProperty("Connection", "Close");
                for (Map.Entry entry : this.requestHeader.entrySet()) {
                    this.connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
                int lookupTry = 0;
                while (true) {
                    try {
                        this.connection.connect();
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (++lookupTry > 3) {
                            throw unknownHostException;
                        }
                        Thread.sleep(200L);
                        continue;
                    }
                    break;
                }
                outputStream = this.connection.getOutputStream();
                writer = new OutputStreamWriter(outputStream);
                writer.write(data);
                writer.flush();
                isr = new InputStreamReader(this.connection.getInputStream(), this.getCharset());
                reader = new BufferedReader(isr);
                StringBuilder stringBuilder = new StringBuilder();
                while ((str = reader.readLine()) != null) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("\r\n");
                    }
                    stringBuilder.append(str);
                }
                string = stringBuilder.toString();
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (Throwable throwable4) {
                    // empty catch block
                }
                try {
                    isr.close();
                }
                catch (Throwable throwable5) {
                    // empty catch block
                }
                try {
                    writer.close();
                }
                catch (Throwable throwable6) {
                    // empty catch block
                }
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    this.connection.disconnect();
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                isr.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                writer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.connection.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return string;
        }
    }

    public void putRequestHeader(String key, String value) {
        this.requestHeader.put(key, value);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setHeaderDebug(boolean headerDebug) {
        this.headerDebug = headerDebug;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }
}

