/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.appwork.utils.JDK8BufferHelper;
import org.appwork.utils.ReusableByteArrayOutputStream;

public class LineParsingOutputStream
extends OutputStream {
    protected final ReusableByteArrayOutputStream bos = new ReusableByteArrayOutputStream(4096);
    protected boolean closed;
    protected final Charset charset;
    protected NEWLINE lastNewLine = null;
    protected final CharsetDecoder decoder;
    protected final StringBuilder sb;
    protected int lastIndex = 0;
    protected final CharBuffer cb;
    protected long lines = 0L;

    public long getLines() {
        return this.lines;
    }

    public LineParsingOutputStream(Charset charset, int bufferSize) {
        if (charset == null) {
            throw new IllegalArgumentException("charset is null!");
        }
        this.charset = charset;
        this.decoder = this.charset.newDecoder();
        this.sb = new StringBuilder(bufferSize);
        this.cb = CharBuffer.wrap(new char[bufferSize]);
    }

    public LineParsingOutputStream(Charset charset) {
        this(charset, 4096);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        this.bos.write(b);
        this.forwardLinesToSink();
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.forwardLinesToSink();
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        this.bos.write(b, off, len);
        this.forwardLinesToSink();
    }

    protected final int forwardLinesToSink() throws IOException {
        CoderResult result;
        ByteBuffer bb = ByteBuffer.wrap(this.bos.getInternalBuffer(), 0, this.bos.size());
        while (true) {
            result = this.decoder.decode(bb, this.cb, this.closed);
            if (this.cb.position() > 0) {
                this.sb.append(this.cb.array(), 0, this.cb.position());
                JDK8BufferHelper.clear(this.cb);
            }
            if (result.isError()) {
                this.sb.append(this.decoder.replacement());
                JDK8BufferHelper.position(bb, bb.position() + result.length());
                continue;
            }
            if (!result.isOverflow()) break;
        }
        if (!result.isUnderflow()) {
            System.out.println(result);
        }
        if (bb.remaining() == 0) {
            this.bos.reset();
        } else if (bb.position() > 0) {
            int position = bb.position();
            int remaining = bb.remaining();
            System.arraycopy(this.bos.getInternalBuffer(), position, this.bos.getInternalBuffer(), 0, remaining);
            this.bos.setUsed(remaining);
        }
        int lines = 0;
        if (this.sb.length() > 0) {
            int index;
            int removeIndex = -1;
            for (index = this.lastIndex; index < this.sb.length(); ++index) {
                char c = this.sb.charAt(index);
                if (c == '\r') {
                    this.lastNewLine = NEWLINE.CR;
                    this.onNextLine(this.lastNewLine, lines, this.sb, this.lastIndex, index);
                    ++lines;
                    removeIndex = index + 1;
                    this.lastIndex = index + 1;
                    continue;
                }
                if (c == '\n') {
                    if (this.lastNewLine == NEWLINE.CR) {
                        this.lastNewLine = NEWLINE.LF;
                    } else {
                        this.lastNewLine = NEWLINE.LF;
                        this.onNextLine(this.lastNewLine, lines, this.sb, this.lastIndex, index);
                        ++lines;
                    }
                    removeIndex = index + 1;
                    this.lastIndex = index + 1;
                    continue;
                }
                this.lastNewLine = null;
            }
            if (removeIndex > 0) {
                this.sb.delete(0, removeIndex);
                this.lastIndex = 0;
            }
            if (this.sb.length() > 0 && this.closed) {
                this.onNextLine(null, lines, this.sb, 0, this.sb.length());
                ++lines;
                this.sb.delete(0, this.sb.length());
            }
            while (this.sb.length() > 0 && (index = this.split(this.sb)) > 0) {
                this.onNextLine(null, lines, this.sb, 0, index);
                ++lines;
                this.sb.delete(0, index);
            }
            this.lines += (long)lines;
        }
        return lines;
    }

    protected int split(StringBuilder sb) {
        return 0;
    }

    protected void onNextLine(NEWLINE newLine, long line, StringBuilder sb, int startIndex, int endIndex) {
    }

    public static enum NEWLINE {
        CR,
        LF;

    }
}

