/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.appwork.utils.net.LineParsingOutputStream;

public class LineParsingInputStream
extends FilterInputStream {
    protected final LineParsingOutputStream os;
    protected final InputStream is;

    public LineParsingInputStream(InputStream is, Charset charset) {
        this(is, charset, 4096);
    }

    public LineParsingInputStream(InputStream is, Charset charset, int bufferSize) {
        super(is);
        this.is = is;
        this.os = this.createOutputStream(charset, bufferSize);
    }

    protected LineParsingOutputStream createOutputStream(Charset charset, int bufferSize) {
        return new LineParsingOutputStream(charset, bufferSize){

            @Override
            protected void onNextLine(LineParsingOutputStream.NEWLINE newLine, long line, StringBuilder sb, int startIndex, int endIndex) {
                LineParsingInputStream.this.onNextLine(newLine, line, sb, startIndex, endIndex);
            }
        };
    }

    @Override
    public int read() throws IOException {
        int ret = super.read();
        if (ret != -1) {
            this.os.write(ret);
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = super.read(b, off, len);
        if (ret > 0) {
            this.os.write(b, off, ret);
        }
        return ret;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.os.close();
        }
    }

    public long getLines() {
        return this.os.getLines();
    }

    protected void onNextLine(LineParsingOutputStream.NEWLINE newLine, long line, StringBuilder sb, int startIndex, int endIndex) {
    }
}

