/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Input2OutputStreamForwarder {
    private final InputStream in;
    private final OutputStream out;
    final byte[] buffer;
    long inC = 0L;
    long outC = 0L;
    int readP = 0;
    int writeF = 0;
    int readF = 0;
    int writeP = 0;
    int readS = 0;
    int writeS = 0;
    final Object LOCK = new Object();
    protected Thread thread = null;
    private IOException outE = null;
    private volatile boolean eof = false;
    private volatile boolean readDone = false;

    public Input2OutputStreamForwarder(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.buffer = new byte[0x100000];
        this.createstartThread();
    }

    public Input2OutputStreamForwarder(InputStream in, OutputStream out, byte[] buffer) {
        this.in = in;
        this.out = out;
        if (buffer == null || buffer.length < 1024) {
            throw new IllegalArgumentException("invalid buffer");
        }
        this.buffer = buffer;
        this.createstartThread();
    }

    public Input2OutputStreamForwarder(InputStream in, OutputStream out, int size) {
        this.in = in;
        this.out = out;
        if (size < 1024) {
            throw new IllegalArgumentException("invalid buffer size");
        }
        this.buffer = new byte[size];
        this.createstartThread();
    }

    private void createstartThread() {
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    while (!Input2OutputStreamForwarder.this.thread.isInterrupted()) {
                        Object object = Input2OutputStreamForwarder.this.LOCK;
                        synchronized (object) {
                            if (Input2OutputStreamForwarder.this.writeF > Input2OutputStreamForwarder.this.readF) {
                                Input2OutputStreamForwarder.this.readP = 0;
                                Input2OutputStreamForwarder.this.readF = Input2OutputStreamForwarder.this.writeF;
                            }
                            if (Input2OutputStreamForwarder.this.readP < Input2OutputStreamForwarder.this.writeP) {
                                Input2OutputStreamForwarder.this.readS = Input2OutputStreamForwarder.this.writeP - Input2OutputStreamForwarder.this.readP;
                            } else if (Input2OutputStreamForwarder.this.writeP < Input2OutputStreamForwarder.this.readP) {
                                Input2OutputStreamForwarder.this.readS = Input2OutputStreamForwarder.this.buffer.length - Input2OutputStreamForwarder.this.readP;
                            } else {
                                if (Input2OutputStreamForwarder.this.eof) return;
                                if (Input2OutputStreamForwarder.this.readDone) {
                                    return;
                                }
                                try {
                                    Input2OutputStreamForwarder.this.LOCK.wait(100L);
                                    continue;
                                }
                                catch (InterruptedException e) {
                                    return;
                                }
                            }
                        }
                        Input2OutputStreamForwarder.this.out.write(Input2OutputStreamForwarder.this.buffer, Input2OutputStreamForwarder.this.readP, Input2OutputStreamForwarder.this.readS);
                        Input2OutputStreamForwarder.this.outC += (long)Input2OutputStreamForwarder.this.readS;
                        System.out.println(Input2OutputStreamForwarder.this.thread.getName() + " : " + Input2OutputStreamForwarder.this.outC + " bytes");
                        object = Input2OutputStreamForwarder.this.LOCK;
                        synchronized (object) {
                            Input2OutputStreamForwarder.this.readP += Input2OutputStreamForwarder.this.readS;
                            Input2OutputStreamForwarder.this.LOCK.notifyAll();
                        }
                    }
                    return;
                }
                catch (IOException e) {
                    Input2OutputStreamForwarder.this.outE = e;
                    return;
                }
                finally {
                    Object object = Input2OutputStreamForwarder.this.LOCK;
                    synchronized (object) {
                        Input2OutputStreamForwarder.this.LOCK.notifyAll();
                    }
                }
            }
        }, this.in + " >> " + this.out);
    }

    public void forward() throws IOException, InterruptedException {
        this.forward(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void forward(Runnable runAfter) throws IOException, InterruptedException {
        try {
            this.thread.start();
            int read = 0;
            while (!this.thread.isInterrupted() && this.thread.isAlive()) {
                Object object;
                block27: {
                    block28: {
                        block26: {
                            object = this.LOCK;
                            // MONITORENTER : object
                            if (this.readP == this.buffer.length && this.readF == this.writeF) {
                                this.writeP = 0;
                                ++this.writeF;
                            }
                            if (this.writeP >= this.buffer.length) break block26;
                            this.writeS = this.buffer.length - this.writeP;
                            // MONITOREXIT : object
                            read = this.in.read(this.buffer, this.writeP, this.writeS);
                            if (read != -1) break block27;
                            break block28;
                        }
                        this.LOCK.notifyAll();
                        try {
                            if (!this.thread.isAlive() || this.thread.isInterrupted()) {
                                // MONITOREXIT : object
                                break;
                            }
                            this.LOCK.wait(100L);
                            // MONITOREXIT : object
                            continue;
                        }
                        catch (InterruptedException e) {
                            // MONITOREXIT : object
                            break;
                        }
                    }
                    this.eof = true;
                    break;
                }
                this.inC += (long)read;
                object = this.LOCK;
                // MONITORENTER : object
                this.writeP += read;
                // MONITOREXIT : object
            }
            if (this.outE == null) return;
            throw this.outE;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                this.readDone = true;
                Object object = this.LOCK;
            }
            catch (Throwable throwable) {
                if (runAfter == null) throw throwable;
                runAfter.run();
                throw throwable;
            }
        }
    }

    public long getInC() {
        return this.inC;
    }

    public long getOutC() {
        return this.outC;
    }
}

