/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.appwork.utils.net.HTTPHeader;

public class HeaderCollection
implements Iterable<HTTPHeader> {
    private final CopyOnWriteArrayList<HTTPHeader> collection = new CopyOnWriteArrayList();
    private final CopyOnWriteArraySet<String> allowedDuplicatedKeys = new CopyOnWriteArraySet();

    public HeaderCollection() {
        this.allowedDuplicatedKeys.add("Set-Cookie".toLowerCase(Locale.ENGLISH));
    }

    public HTTPHeader add(HTTPHeader header) {
        HTTPHeader existingHeader = this.get(header.getKey());
        if (existingHeader != null && !this.allowedDuplicatedKeys.contains(header.getKey().toLowerCase(Locale.ENGLISH))) {
            if (existingHeader.isAllowOverwrite()) {
                int index = this.indexOf(existingHeader);
                return this.collection.set(index, header);
            }
            return null;
        }
        this.collection.add(header);
        return null;
    }

    public void clear() {
        this.collection.clear();
    }

    public HeaderCollection clone() {
        HeaderCollection ret = new HeaderCollection();
        ret.allowedDuplicatedKeys.clear();
        ret.allowedDuplicatedKeys.addAll(this.getAllowedDuplicatedKeys());
        ret.collection.addAll(this.collection);
        return ret;
    }

    public HTTPHeader get(int index) {
        return this.collection.get(index);
    }

    public int indexOf(HTTPHeader header) {
        return this.collection.indexOf(header);
    }

    public HTTPHeader get(String key) {
        if (key == null) {
            return null;
        }
        for (HTTPHeader header : this.collection) {
            if (!(header.getKey() == null ? key == null : header.getKey().equalsIgnoreCase(key))) continue;
            return header;
        }
        return null;
    }

    public List<HTTPHeader> getAll(String key) {
        ArrayList<HTTPHeader> ret = new ArrayList<HTTPHeader>();
        for (HTTPHeader header : this.collection) {
            if (!header.getKey().equalsIgnoreCase(key)) continue;
            ret.add(header);
        }
        if (ret.size() > 0) {
            return ret;
        }
        return null;
    }

    public CopyOnWriteArraySet<String> getAllowedDuplicatedKeys() {
        return this.allowedDuplicatedKeys;
    }

    public String getValue(String key) {
        HTTPHeader ret = this.get(key);
        if (ret != null) {
            return ret.getValue();
        }
        return null;
    }

    @Override
    public Iterator<HTTPHeader> iterator() {
        return this.collection.iterator();
    }

    public HTTPHeader remove(HTTPHeader header) {
        if (this.collection.remove(header)) {
            return header;
        }
        return this.remove(header.getKey());
    }

    public HTTPHeader remove(String key) {
        HTTPHeader existingHeader = this.get(key);
        if (existingHeader != null && this.collection.remove(existingHeader)) {
            return existingHeader;
        }
        return null;
    }

    public int size() {
        return this.collection.size();
    }

    public String toString() {
        return this.collection.toString();
    }

    public boolean addIfAbsent(HTTPHeader httpHeader) {
        if (this.get(httpHeader.getKey()) == null) {
            this.add(httpHeader);
            return true;
        }
        return false;
    }
}

