/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.appwork.utils.net.ChunkedOutputStream;

public class DeChunkingOutputStream
extends OutputStream {
    protected final OutputStream os;
    protected int nextExpectedChunkLeft = 0;
    protected byte[] chunkSize = new byte[8];
    protected int chunkSizePosition = 0;
    protected boolean chunkedExtension = false;
    protected boolean chunkedTrailers = false;
    private int lastWrite = -1;

    public static void main(String[] args) throws Throwable {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ChunkedOutputStream cos = new ChunkedOutputStream((OutputStream)new DeChunkingOutputStream(bos), 0);
        cos.write("Hello ".getBytes("UTF-8"));
        cos.write("H".getBytes("UTF-8"));
        cos.write("ell".getBytes("UTF-8"));
        cos.write("o! ".getBytes("UTF-8"));
        cos.write("Hello This is a simple Test".getBytes("UTF-8"));
        cos.close();
        System.out.println("Output: " + new String(bos.toByteArray(), "UTF-8"));
    }

    public DeChunkingOutputStream(OutputStream os) {
        this.os = os;
    }

    @Override
    public void close() throws IOException {
        if (this.nextExpectedChunkLeft > 0) {
            throw new IOException("malformed chunk, still " + this.nextExpectedChunkLeft + " bytes expected!");
        }
        this.os.close();
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    protected int nextChunkInfoProcessed(int b) throws IOException {
        if (this.nextExpectedChunkLeft > 0) {
            return this.nextExpectedChunkLeft;
        }
        if (this.lastWrite == 13 || this.lastWrite == 10) {
            boolean returnChunkSize;
            boolean bl = returnChunkSize = this.lastWrite == 10;
            if (this.lastWrite == 13 && b != 10) {
                throw new IOException("malformed chunk, bad/missing LF/CRLF");
            }
            this.lastWrite = -1;
            this.chunkedExtension = false;
            if (this.chunkSizePosition > 0) {
                String size = new String(this.chunkSize, 0, this.chunkSizePosition, "UTF-8");
                this.nextExpectedChunkLeft = Integer.parseInt(size.toString().trim(), 16);
                this.chunkSizePosition = 0;
                if (this.nextExpectedChunkLeft == 0) {
                    this.chunkedTrailers = true;
                }
            }
            if (returnChunkSize) {
                return this.nextExpectedChunkLeft;
            }
            return 0;
        }
        if (b != 10 && b != 13) {
            if (b == 59) {
                this.chunkedExtension = true;
            } else if (!this.chunkedExtension) {
                this.chunkSize[this.chunkSizePosition++] = (byte)b;
            }
        } else {
            this.lastWrite = b;
        }
        return this.nextExpectedChunkLeft;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.chunkedTrailers) {
            return;
        }
        if (this.nextExpectedChunkLeft >= len) {
            this.os.write(b, off, len);
            this.nextExpectedChunkLeft -= len;
        } else {
            int rest = len;
            int done = 0;
            int next = 0;
            while (rest > 0 && !this.chunkedTrailers) {
                next = Math.min(this.nextExpectedChunkLeft, rest);
                if (next > 0) {
                    this.os.write(b, off + done, next);
                    this.nextExpectedChunkLeft -= next;
                    rest -= next;
                    done += next;
                    continue;
                }
                int temp = b[off + done] & 0xFF;
                --rest;
                ++done;
                this.nextChunkInfoProcessed(temp);
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.chunkedTrailers) {
            return;
        }
        if (this.nextChunkInfoProcessed(b) > 0) {
            this.os.write(b);
            --this.nextExpectedChunkLeft;
        }
    }
}

