/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.IOException;
import java.io.OutputStream;
import org.appwork.utils.net.CountingConnection;

public class CountingOutputStream
extends OutputStream
implements CountingConnection {
    protected OutputStream os;
    protected volatile long written = 0L;

    public CountingOutputStream(OutputStream os) {
        this.os = os;
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public long transferedBytes() {
        return this.written;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.os.write(b);
        this.written += (long)b.length;
    }

    public void setTransferedBytes(long written) {
        if (written >= 0L) {
            this.written = written;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
        this.written += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
        ++this.written;
    }
}

