/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging2.sendlogs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import org.appwork.swing.action.BasicAction;
import org.appwork.swing.exttable.AlternateHighlighter;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtComponentRowHighlighter;
import org.appwork.swing.exttable.ExtTable;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.utils.ColorUtils;
import org.appwork.utils.logging2.sendlogs.LogFolder;
import org.appwork.utils.logging2.sendlogs.LogModel;
import org.appwork.utils.logging2.sendlogs.T;

public class LogTable
extends ExtTable<LogFolder> {
    public LogTable(LogModel model) {
        super(model);
        this.setShowVerticalLines(true);
        this.setShowGrid(true);
        this.setShowHorizontalLines(true);
        this.setSelectionMode(2);
        Color b2 = this.getForeground();
        Color f2 = this.getBackground();
        ((ExtTableModel)this.getModel()).addExtComponentRowHighlighter(new ExtComponentRowHighlighter<LogFolder>(f2, b2, null){

            @Override
            public boolean accept(ExtColumn<LogFolder> column, LogFolder value, boolean selected, boolean focus, int row) {
                return selected;
            }
        });
        ((ExtTableModel)this.getModel()).addExtComponentRowHighlighter(new ExtComponentRowHighlighter<LogFolder>(null, Color.ORANGE, null){

            @Override
            public boolean accept(ExtColumn<LogFolder> column, LogFolder value, boolean selected, boolean focus, int row) {
                return value.isCurrent();
            }
        });
        this.addRowHighlighter(new AlternateHighlighter(null, ColorUtils.getAlphaInstance(new JLabel().getForeground(), 6)));
        this.setIntercellSpacing(new Dimension(0, 0));
    }

    @Override
    protected JPopupMenu onContextMenu(JPopupMenu popup, LogFolder contextObject, final List<LogFolder> selection, ExtColumn<LogFolder> column, MouseEvent mouseEvent) {
        popup.add(new BasicAction(){
            {
                this.setName(T.T.LogTable_onContextMenu_enable_());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                for (LogFolder f : selection) {
                    f.setSelected(true);
                }
                LogTable.this.repaint();
            }
        });
        popup.add(new BasicAction(){
            {
                this.setName(T.T.LogTable_onContextMenu_disable_());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                for (LogFolder f : selection) {
                    f.setSelected(false);
                }
                LogTable.this.repaint();
            }
        });
        return popup;
    }
}

