/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging2.sendlogs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.appwork.swing.MigPanel;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtCheckColumn;
import org.appwork.swing.exttable.columns.ExtComponentColumn;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.logging2.sendlogs.LogFolder;
import org.appwork.utils.logging2.sendlogs.T;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.DialogIcon;
import org.appwork.utils.swing.renderer.RendererMigPanel;

public class LogModel
extends ExtTableModel<LogFolder> {
    public LogModel(List<LogFolder> folders) {
        super("LogModel");
        Collections.sort(folders, new Comparator<LogFolder>(){

            @Override
            public int compare(LogFolder o1, LogFolder o2) {
                return CompareUtils.compare(o2.getCreated(), o1.getCreated());
            }
        });
        for (LogFolder folder : folders) {
            if (!folder.isCurrent()) continue;
            folders.remove(folder);
            folders.add(0, folder);
            break;
        }
        this.setTableData(folders);
    }

    @Override
    protected void initColumns() {
        this.addColumn(new ExtCheckColumn<LogFolder>(T.T.LogModel_initColumns_check_upload_()){

            @Override
            protected boolean getBooleanValue(LogFolder value) {
                return value.isSelected();
            }

            @Override
            public boolean isEditable(LogFolder obj) {
                return true;
            }

            @Override
            public int getDefaultWidth() {
                return 100;
            }

            @Override
            public int getMaxWidth() {
                return 120;
            }

            @Override
            public boolean isSortable(LogFolder obj) {
                return false;
            }

            @Override
            protected void setBooleanValue(boolean value, LogFolder object) {
                object.setSelected(value);
            }
        });
        this.addColumn(new ExtTextColumn<LogFolder>(T.T.LogModel_initColumns_time_()){
            {
                this.setRowSorter(new ExtDefaultRowSorter<LogFolder>(){

                    @Override
                    public int compare(LogFolder o1, LogFolder o2) {
                        if (this.getSortOrderIdentifier() != "ASC") {
                            return CompareUtils.compare(o1.getCreated(), o2.getCreated());
                        }
                        return CompareUtils.compare(o2.getCreated(), o1.getCreated());
                    }
                });
            }

            @Override
            public boolean isResizable() {
                return true;
            }

            @Override
            public String getStringValue(LogFolder value) {
                String from = DateFormat.getInstance().format(new Date(value.getCreated()));
                if (value.isCurrent()) {
                    return T.T.LogModel_current(from);
                }
                String to = DateFormat.getInstance().format(new Date(value.getLastModified()));
                String stringValue = T.T.LogModel_getStringValue_between_(from, to);
                return stringValue;
            }

            @Override
            public boolean isSortable(LogFolder obj) {
                return false;
            }
        });
        this.addColumn(new ExtComponentColumn<LogFolder>(_AWU.T.DIALOG_FILECHOOSER_directoryDescriptionText()){
            private JButton editorBtn;
            private JButton rendererBtn;
            private LogFolder editing;
            protected MigPanel editor;
            protected RendererMigPanel renderer;
            {
                this.editorBtn = new JButton("");
                this.editorBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        File logFolder;
                        File file = logFolder = editing != null ? editing.getFolder() : null;
                        if (logFolder.isDirectory()) {
                            CrossSystem.openFile(logFolder);
                        }
                    }
                });
                this.rendererBtn = new JButton("");
                this.editor = new MigPanel("ins 1", "[grow,fill]", "[18!]"){

                    @Override
                    public void requestFocus() {
                    }
                };
                this.editor.add(this.editorBtn);
                this.renderer = new RendererMigPanel("ins 1", "[grow,fill]", "[18!]");
                this.renderer.add(this.rendererBtn);
                this.setClickcount(1);
                this.rendererBtn.setIcon(DialogIcon.DIALOG_FIND.get(16));
                this.rendererBtn.setText(_AWU.T.DIALOG_FILECHOOSER_directoryOpenButtonText());
                this.editorBtn.setIcon(DialogIcon.DIALOG_FIND.get(16));
                this.editorBtn.setText(_AWU.T.DIALOG_FILECHOOSER_directoryOpenButtonText());
            }

            @Override
            protected String generateID() {
                return "LogFolder.directory";
            }

            @Override
            public boolean isResizable() {
                return true;
            }

            @Override
            public int getDefaultWidth() {
                return 80;
            }

            @Override
            public boolean isAutoWidthEnabled() {
                return true;
            }

            @Override
            public boolean isSortable(LogFolder obj) {
                return false;
            }

            @Override
            protected JComponent getInternalEditorComponent(LogFolder value, boolean isSelected, int row, int column) {
                return this.editor;
            }

            @Override
            protected JComponent getInternalRendererComponent(LogFolder value, boolean isSelected, boolean hasFocus, int row, int column) {
                return this.renderer;
            }

            @Override
            public void configureRendererComponent(LogFolder value, boolean isSelected, boolean hasFocus, int row, int column) {
            }

            @Override
            public void configureEditorComponent(LogFolder value, boolean isSelected, int row, int column) {
                this.editing = value;
            }

            @Override
            public void resetEditor() {
            }

            @Override
            public void resetRenderer() {
            }
        });
    }
}

