/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging2.sendlogs;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.appwork.exceptions.WTFException;
import org.appwork.swing.action.BasicAction;
import org.appwork.utils.Application;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.logging2.sendlogs.LogFolder;
import org.appwork.utils.logging2.sendlogs.SendLogDialog;
import org.appwork.utils.logging2.sendlogs.T;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.ProgressDialog;
import org.appwork.utils.zip.ZipIOException;
import org.appwork.utils.zip.ZipIOWriter;

public abstract class AbstractLogAction
extends BasicAction {
    protected int total;
    protected int current;

    @Override
    public void actionPerformed(ActionEvent e) {
        ProgressDialog p = new ProgressDialog(new ProgressDialog.ProgressGetter(){

            @Override
            public String getLabelString() {
                return null;
            }

            @Override
            public int getProgress() {
                return -1;
            }

            @Override
            public String getString() {
                return T.T.LogAction_getString_uploading_();
            }

            @Override
            public void run() throws Exception {
                AbstractLogAction.this.create();
            }
        }, 8, T.T.LogAction_actionPerformed_zip_title_(), T.T.LogAction_actionPerformed_wait_(), null, null, null);
        try {
            Dialog.getInstance().showDialog(p);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected SendLogDialog getSendLogDialog(List<LogFolder> folders) {
        return new SendLogDialog(folders);
    }

    protected void create() throws DialogClosedException, DialogCanceledException {
        ArrayList<LogFolder> folders = AbstractLogAction.getLogFolders();
        LogFolder currentLog = null;
        LogFolder latestLog = null;
        for (LogFolder folder : folders) {
            if (this.isCurrentLogFolder(folder.getCreated())) {
                folder.setNeedsFlush(true);
                currentLog = folder;
            }
            if (latestLog != null && folder.getCreated() <= latestLog.getCreated()) continue;
            latestLog = folder;
        }
        if (currentLog != null) {
            currentLog.setSelected(true);
            currentLog.setCurrent(true);
        } else if (latestLog != null) {
            latestLog.setSelected(true);
        }
        SendLogDialog d = this.getSendLogDialog(folders);
        Dialog.getInstance().showDialog(d);
        final List<LogFolder> selection = d.getSelectedFolders();
        if (selection.size() == 0) {
            return;
        }
        this.total = selection.size();
        this.current = 0;
        ProgressDialog p = new ProgressDialog(new ProgressDialog.ProgressGetter(){

            @Override
            public String getLabelString() {
                return null;
            }

            @Override
            public int getProgress() {
                if (AbstractLogAction.this.current == 0) {
                    return -1;
                }
                return Math.min(99, AbstractLogAction.this.current * 100 / AbstractLogAction.this.total);
            }

            @Override
            public String getString() {
                return T.T.LogAction_getString_uploading_();
            }

            @Override
            public void run() throws Exception {
                try {
                    AbstractLogAction.this.createPackage(selection);
                }
                catch (WTFException e) {
                    throw new InterruptedException();
                }
            }
        }, 8, T.T.LogAction_actionPerformed_zip_title_(), T.T.LogAction_actionPerformed_wait_(), null, null, null);
        Dialog.getInstance().showDialog(p);
    }

    public static ArrayList<LogFolder> getLogFolders() {
        File[] logs = Application.getResource("logs").listFiles();
        ArrayList<LogFolder> folders = new ArrayList<LogFolder>();
        if (logs != null) {
            for (File f : logs) {
                String timestampString = new Regex(f.getName(), "(\\d{7,})_").getMatch(0);
                if (timestampString == null) continue;
                LogFolder logFolder = new LogFolder(f, Long.parseLong(timestampString));
                folders.add(logFolder);
            }
            Collections.sort(folders, new Comparator<LogFolder>(){

                @Override
                private final int compare(long x, long y) {
                    return x < y ? -1 : (x == y ? 0 : 1);
                }

                @Override
                public int compare(LogFolder o1, LogFolder o2) {
                    return this.compare(o2.getCreated(), o1.getCreated());
                }
            });
        }
        return folders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createPackage(List<LogFolder> selection) throws Exception {
        for (LogFolder lf : selection) {
            File zip = Application.getTempResource("logs/logPackage.zip");
            zip.delete();
            zip.getParentFile().mkdirs();
            ZipIOWriter writer = null;
            String name = lf.getFolder().getName() + "-" + this.format(lf.getCreated()) + " to " + this.format(lf.getLastModified());
            File folder = Application.getTempResource("logs/" + name);
            try {
                if (lf.isNeedsFlush()) {
                    this.flushLogs();
                }
                writer = new ZipIOWriter(zip){

                    @Override
                    public void addFile(File addFile, boolean compress, String fullPath) throws FileNotFoundException, ZipIOException, IOException {
                        if (addFile.getName().endsWith(".lck") || addFile.isFile() && addFile.length() == 0L) {
                            return;
                        }
                        if (Thread.currentThread().isInterrupted()) {
                            throw new WTFException("INterrupted");
                        }
                        super.addFile(addFile, compress, fullPath);
                    }
                };
                if (folder.exists()) {
                    Files.deleteRecursiv(folder);
                }
                IO.copyFolderRecursive(lf.getFolder(), folder, true);
                writer.addDirectory(folder, true, null);
            }
            finally {
                try {
                    writer.close();
                }
                catch (Throwable throwable) {}
            }
            this.onNewPackage(zip, this.format(lf.getCreated()) + "-" + this.format(lf.getLastModified()));
            ++this.current;
        }
    }

    protected abstract void flushLogs();

    protected String format(long created) {
        Date date = new Date(created);
        return new SimpleDateFormat("dd.MM.yy HH.mm.ss", Locale.GERMANY).format(date);
    }

    protected abstract boolean isCurrentLogFolder(long var1);

    protected abstract void onNewPackage(File var1, String var2) throws IOException;
}

