/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging2;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Application;
import org.appwork.utils.Files;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogConfig;
import org.appwork.utils.logging2.LogConsoleHandler;
import org.appwork.utils.logging2.LogSink;
import org.appwork.utils.logging2.LogSinkFileHandler;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.LogSourceFormatter;
import org.appwork.utils.os.CrossSystem;

public abstract class LogSourceProvider {
    protected static final String LOG_INIT_DONE = "LOG_INIT_DONE";
    protected final HashMap<String, LogSink> logSinks = new HashMap();
    private final int maxSize;
    private final int maxLogs;
    protected long logTimeout;
    protected Thread flushThread = null;
    protected final File logFolder;
    protected LogConsoleHandler consoleHandler;
    protected boolean instantFlushDefault;
    private final boolean debugMode;
    private long initTime;
    private final boolean writeLogs;
    private File logBaseFolder;
    static List<LogSourceProvider> INSTANCES = new ArrayList<LogSourceProvider>();
    private static final AtomicBoolean TRASHLOCK = new AtomicBoolean(false);
    static final Object INIT_LOCK = new Object();
    public static final String LOG_NO_CONSOLE = "LOG_NO_CONSOLE";
    public static final String LOG_NO_FILE = "LOG_NO_FILE";
    public static final String LOG_SINGLE_LOGGER_NAME = "LOG_SINGLE_LOGGER_NAME";
    private static boolean FIRST = true;
    public static boolean AUTO_CLEANUP = true;

    public long getLogTimeout() {
        return this.logTimeout;
    }

    public void setLogTimeout(long logTimeout) {
        this.logTimeout = logTimeout;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<LogSourceProvider> getInstances() {
        Object object = INIT_LOCK;
        synchronized (object) {
            return new ArrayList<LogSourceProvider>(INSTANCES);
        }
    }

    public boolean isWriteLogs() {
        return this.writeLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogSourceProvider(final long timeStamp) {
        Object object = INIT_LOCK;
        synchronized (object) {
            if (FIRST) {
                FIRST = false;
                ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

                    @Override
                    public void onShutdown(ShutdownRequest shutdownRequest) {
                        LogSourceProvider.flushAllSinks(LogSink.FLUSH.CLOSE);
                    }

                    @Override
                    public String toString() {
                        return "flushing logs to disk";
                    }
                });
            }
            this.initTime = timeStamp;
            if (!"true".equalsIgnoreCase(System.getProperty(LOG_NO_CONSOLE))) {
                this.consoleHandler = new LogConsoleHandler();
            }
            final LogConfig config = JsonConfig.create(LogConfig.class);
            this.maxSize = config.getMaxLogFileSize();
            this.writeLogs = this.maxSize > 102400 && !"true".equalsIgnoreCase(System.getProperty(LOG_NO_FILE));
            this.maxLogs = config.getMaxLogFiles();
            this.logTimeout = (long)config.getLogFlushTimeout() * 1000L;
            this.instantFlushDefault = this.debugMode = config.isDebugModeEnabled();
            this.logBaseFolder = Application.getResource("logs");
            if (System.getProperty("LOG_BASE_DIRECTORY") != null) {
                this.logBaseFolder = new File(System.getProperty("LOG_BASE_DIRECTORY"));
            }
            if (INSTANCES.size() > 0) {
                for (LogSourceProvider p : INSTANCES) {
                    System.out.println("Multiple LogControllers Detected: " + p.getClass().getName() + "|" + p);
                }
                System.out.println("Multiple LogControllers Detected: " + this.getClass().getName() + "|" + this);
                this.logFolder = INSTANCES.get(0).getLogFolder();
                int currentLength = String.valueOf(System.currentTimeMillis()).length();
                String regex = "^(\\d{" + (currentLength - 1) + "," + (currentLength + 1) + "})_.+";
                String timeStampString = new Regex(this.logFolder.getName(), regex).getMatch(0);
                this.initTime = Long.parseLong(timeStampString);
            } else {
                File llogFolder = new File(this.logBaseFolder, timeStamp + "_" + new SimpleDateFormat("EEE, MMM d, yyyy HH.mm Z", Locale.ENGLISH).format(new Date(timeStamp)) + "/");
                int i = 2;
                while (llogFolder.exists()) {
                    llogFolder = new File(this.logBaseFolder, timeStamp + "_" + new SimpleDateFormat("EEE, MMM d, yyyy HH.mm Z", Locale.ENGLISH).format(new Date(timeStamp)) + "_" + i++ + "/");
                }
                this.logFolder = llogFolder;
            }
            if (!this.logFolder.exists() && this.isWriteLogs()) {
                this.logFolder.mkdirs();
            }
            if (TRASHLOCK.compareAndSet(false, true) && AUTO_CLEANUP) {
                new Thread("LogsCleanup"){
                    long newestTimeStamp;
                    {
                        super(x0);
                        this.newestTimeStamp = -1L;
                    }

                    @Override
                    public void run() {
                        File[] oldLogs = LogSourceProvider.this.logBaseFolder.listFiles(new FilenameFilter(){
                            final long removeTimeStamp;
                            final int currentLength;
                            final String regex;
                            {
                                this.removeTimeStamp = timeStamp - (long)(config.getCleanupLogsOlderThanXDays() * 24 * 60 * 60) * 1000L;
                                this.currentLength = String.valueOf(System.currentTimeMillis()).length();
                                this.regex = "^(\\d{" + (this.currentLength - 1) + "," + (this.currentLength + 1) + "})_.+";
                            }

                            @Override
                            public boolean accept(File dir, String name) {
                                if (dir.exists() && dir.isDirectory() && name.matches(this.regex)) {
                                    String timeStamp = new Regex(name, this.regex).getMatch(0);
                                    long times = 0L;
                                    if (timeStamp != null && (times = Long.parseLong(timeStamp)) < this.removeTimeStamp) {
                                        if (newestTimeStamp == -1L || times > newestTimeStamp) {
                                            newestTimeStamp = times;
                                        }
                                        return true;
                                    }
                                }
                                return false;
                            }
                        });
                        if (oldLogs != null) {
                            for (File oldLog : oldLogs) {
                                try {
                                    if (this.newestTimeStamp > 0L && oldLog.getName().contains(this.newestTimeStamp + "")) continue;
                                    Files.deleteRecursiv(oldLog);
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                }.start();
            }
            INSTANCES.add(this);
            System.setProperty(LOG_INIT_DONE, INSTANCES.size() + " instances");
        }
    }

    public File getLogFolder() {
        return this.logFolder;
    }

    protected LogSource createLogSource(String name, int i) {
        return new LogSource(name, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushSinks(LogSink.FLUSH flush) {
        ArrayList<LogSink> logSinks2Flush = null;
        ArrayList<LogSink> logSinks2Close = null;
        Iterator iterator = this.logSinks;
        synchronized (iterator) {
            logSinks2Flush = new ArrayList<LogSink>(this.logSinks.size());
            logSinks2Close = new ArrayList<LogSink>(this.logSinks.size());
            Iterator<LogSink> it = this.logSinks.values().iterator();
            while (it.hasNext()) {
                LogSink next = it.next();
                if (next.hasLogSources()) {
                    logSinks2Flush.add(next);
                    continue;
                }
                if (LogSink.FLUSH.CLOSE.equals((Object)flush)) {
                    it.remove();
                    logSinks2Close.add(next);
                    continue;
                }
                logSinks2Flush.add(next);
            }
        }
        for (LogSink sink : logSinks2Close) {
            try {
                sink.close();
            }
            catch (Throwable throwable) {}
        }
        for (LogSink sink : logSinks2Flush) {
            try {
                sink.flush(flush);
            }
            catch (Throwable throwable) {}
        }
    }

    public LogSource getClassLogger(Class<?> clazz) {
        String name = clazz.getSimpleName();
        if (StringUtils.isEmpty(name)) {
            name = clazz.getName();
        }
        return this.getLogger(name);
    }

    public LogConsoleHandler getConsoleHandler() {
        return this.consoleHandler;
    }

    public LogSource getCurrentClassLogger() {
        Throwable e = null;
        Throwable stackTrace = new Throwable();
        try {
            for (StackTraceElement element : stackTrace.getStackTrace()) {
                String currentClassName = element.getClassName();
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> currentClass = classLoader != null ? Class.forName(currentClassName, true, classLoader) : Class.forName(currentClassName);
                if (Modifier.isAbstract(currentClass.getModifiers()) || Modifier.isInterface(currentClass.getModifiers()) || LogSourceProvider.class.isAssignableFrom(currentClass)) continue;
                return this.getLogger(currentClassName);
            }
        }
        catch (Throwable e2) {
            e = e2;
        }
        LogSource logger = this.getLogger("LogSourceProvider");
        if (e != null) {
            logger.log(e);
        }
        logger.log(stackTrace);
        return logger;
    }

    public long getInitTime() {
        return this.initTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogSource getLogger(String name) {
        LogSink sink = null;
        name = System.getProperty(LOG_SINGLE_LOGGER_NAME, name);
        if (StringUtils.isEmpty(name = CrossSystem.alleviatePathParts(name))) {
            return null;
        }
        if (!name.endsWith(".log")) {
            name = name + ".log";
        }
        Object object = INIT_LOCK;
        synchronized (object) {
            sink = this.getGlobalLockSink(name.toLowerCase(Locale.ENGLISH));
            if (sink == null) {
                sink = new LogSink(name);
                if (this.consoleHandler != null) {
                    sink.addHandler(this.consoleHandler);
                }
                try {
                    if (this.isWriteLogs()) {
                        LogSinkFileHandler fileHandler = new LogSinkFileHandler(new File(this.logFolder, name), this.maxSize, this.maxLogs);
                        fileHandler.setFormatter(new LogSourceFormatter());
                        sink.addHandler(fileHandler);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                this.logSinks.put(name.toLowerCase(Locale.ENGLISH), sink);
                this.startFlushThread();
            }
            LogSource source = this.createLogSource(name, -1);
            source.setInstantFlush(this.isInstantFlushDefault());
            sink.addLogSource(source);
            return source;
        }
    }

    private LogSink getGlobalLockSink(String name) {
        LogSink ret = this.logSinks.get(name);
        if (ret == null) {
            for (LogSourceProvider p : INSTANCES) {
                if (p == this || (ret = p.logSinks.get(name)) == null) continue;
                System.out.println("Use Log Sink from " + p.getClass() + "." + name + " (instead of " + this.getClass().getName() + ")");
                break;
            }
        }
        return ret;
    }

    public LogSource getPreviousThreadLogSource() {
        return LogSource.getPreviousThreadLogSource();
    }

    public boolean isInstantFlushDefault() {
        return this.instantFlushDefault || !this.isWriteLogs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsoleHandler() {
        HashMap<String, LogSink> hashMap = this.logSinks;
        synchronized (hashMap) {
            if (this.consoleHandler == null) {
                return;
            }
            Iterator<LogSink> it = this.logSinks.values().iterator();
            while (it.hasNext()) {
                LogSink next = it.next();
                if (next.hasLogSources()) {
                    next.removeHandler(this.consoleHandler);
                    continue;
                }
                next.close();
                it.remove();
            }
            this.consoleHandler = null;
        }
    }

    protected void startFlushThread() {
        if (this.flushThread != null && this.flushThread.isAlive()) {
            return;
        }
        this.flushThread = new Thread("LogFlushThread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    HashMap<String, LogSink> hashMap = LogSourceProvider.this.logSinks;
                    synchronized (hashMap) {
                        if (LogSourceProvider.this.logSinks.size() == 0) {
                            LogSourceProvider.this.flushThread = null;
                            return;
                        }
                    }
                    try {
                        try {
                            Thread.sleep(LogSourceProvider.this.logTimeout);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        LogSourceProvider.this.flushSinks(LogSink.FLUSH.TIMEOUT);
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
        };
        this.flushThread.setDaemon(true);
        this.flushThread.start();
    }

    public static void flushAllSinks(LogSink.FLUSH flush) {
        for (LogSourceProvider p : LogSourceProvider.getInstances()) {
            if (p == null) continue;
            p.flushSinks(flush);
        }
    }
}

