/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging2;

import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.appwork.utils.Exceptions;
import org.appwork.utils.logging.ExceptionDefaultLogLevel;
import org.appwork.utils.logging2.ClearableLogInterface;
import org.appwork.utils.logging2.ClosableLogInterface;
import org.appwork.utils.logging2.InputStreamLogger;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSink;
import org.appwork.utils.logging2.LogSourceFormatter;

public class LogSource
extends Logger
implements LogInterface,
ClearableLogInterface,
ClosableLogInterface {
    private static WeakHashMap<Thread, WeakReference<LogSource>> LASTTHREADLOGSOURCE = new WeakHashMap();
    private List<LogRecord> records = new ArrayList<LogRecord>();
    private int maxLogRecordsInMemory = -1;
    private int maxSizeInMemory = -1;
    private int currentSizeInMemory = 0;
    private int flushCounter = 0;
    private int recordsCounter = 0;
    private boolean closed = false;
    private boolean allowTimeoutFlush = true;
    private boolean autoFlushOnThrowable = false;
    private boolean instantFlush = false;
    private boolean flushOnFinalize = false;
    private boolean flushOnClose = true;
    private Logger parent = null;

    public static void exception(Logger logger, Throwable e) {
        if (logger == null || e == null) {
            return;
        }
        if (logger instanceof LogSource) {
            ((LogSource)logger).log(e);
        } else {
            logger.severe(Exceptions.getStackTrace(e));
        }
    }

    public static void exception(LogInterface logger, Throwable e) {
        if (logger == null || e == null) {
            return;
        }
        logger.log(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogSource getPreviousThreadLogSource() {
        WeakHashMap<Thread, WeakReference<LogSource>> weakHashMap = LASTTHREADLOGSOURCE;
        synchronized (weakHashMap) {
            Thread thread = Thread.currentThread();
            WeakReference<LogSource> prevLogSource = LASTTHREADLOGSOURCE.get(thread);
            if (prevLogSource != null) {
                LogSource previousLogger = (LogSource)prevLogSource.get();
                if (previousLogger != null && !previousLogger.isClosed()) {
                    return previousLogger;
                }
                LASTTHREADLOGSOURCE.remove(thread);
            }
        }
        return null;
    }

    public boolean isAutoFlushOnThrowable() {
        return this.autoFlushOnThrowable;
    }

    public void setAutoFlushOnThrowable(boolean autoFlushOnThrowable) {
        this.autoFlushOnThrowable = autoFlushOnThrowable;
    }

    public boolean isFlushOnClose() {
        return this.flushOnClose;
    }

    public void setFlushOnClose(boolean flushOnClose) {
        this.flushOnClose = flushOnClose;
    }

    public LogSource(String name) {
        this(name, -1);
    }

    public LogSource(String name, int maxLogRecordsInMemory) {
        this(name, null);
        this.maxLogRecordsInMemory = maxLogRecordsInMemory;
        super.setUseParentHandlers(false);
        this.setLevel(Level.ALL);
    }

    protected LogSource(String name, String resourceBundleName) {
        super(name, resourceBundleName);
        this.setCurrentThreadLogSource();
    }

    @Override
    public synchronized void clear() {
        this.records = null;
    }

    @Override
    public synchronized void close() {
        this.flush();
        this.closed = true;
        this.records = null;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.allowTimeoutFlush || this.flushOnFinalize) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush() {
        if (this.closed) {
            return;
        }
        if (this.records == null || this.records.size() == 0) {
            this.currentSizeInMemory = 0;
            this.records = null;
            return;
        }
        try {
            Logger parent = this.getParent();
            if (parent != null) {
                ++this.flushCounter;
                for (Handler handler : parent.getHandlers()) {
                    if (handler == null || handler instanceof ConsoleHandler) continue;
                    Handler handler2 = handler;
                    synchronized (handler2) {
                        for (LogRecord record : this.records) {
                            handler.publish(record);
                        }
                    }
                }
            }
        }
        finally {
            this.currentSizeInMemory = 0;
            this.records = null;
        }
    }

    public int getMaxLogRecordsInMemory() {
        return this.maxLogRecordsInMemory;
    }

    public int getMaxSizeInMemory() {
        return this.maxSizeInMemory;
    }

    @Override
    public Logger getParent() {
        return this.parent;
    }

    public boolean isAllowTimeoutFlush() {
        return this.allowTimeoutFlush;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    public boolean isFlushOnFinalize() {
        return this.flushOnFinalize;
    }

    public boolean isInstantFlush() {
        return this.instantFlush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void log(LogRecord record) {
        if (this.closed || record == null) {
            return;
        }
        ++this.recordsCounter;
        this.setCurrentThreadLogSource();
        record.setLoggerName(this.getName());
        record.getSourceClassName();
        int recordSize = 0;
        if (record.getMessage() != null) {
            recordSize = record.getMessage().length();
        }
        if (this.maxLogRecordsInMemory == 0 || this.maxSizeInMemory == 0 || this.instantFlush) {
            Logger parent = this.getParent();
            if (parent != null) {
                for (Handler handler : parent.getHandlers()) {
                    if (handler == null) continue;
                    Handler handler2 = handler;
                    synchronized (handler2) {
                        handler.publish(record);
                    }
                }
            }
            return;
        }
        if (this.maxLogRecordsInMemory > 0 && this.records != null && this.records.size() == this.maxLogRecordsInMemory || this.maxSizeInMemory > 0 && this.currentSizeInMemory + recordSize > this.maxSizeInMemory) {
            this.flush();
        }
        if (this.records == null) {
            this.records = new ArrayList<LogRecord>();
        }
        this.currentSizeInMemory += recordSize;
        this.records.add(record);
        super.log(record);
    }

    @Override
    public void log(Throwable e) {
        String thrownAt = null;
        for (StackTraceElement es : new Exception().getStackTrace()) {
            if (LogSource.class.getName().equals(es.getClassName())) continue;
            thrownAt = es.toString();
            break;
        }
        if (e == null) {
            e = new NullPointerException("e is null");
        }
        Level lvl = null;
        if (e instanceof ExceptionDefaultLogLevel) {
            lvl = ((ExceptionDefaultLogLevel)((Object)e)).getDefaultLogLevel();
        }
        if (lvl == null) {
            lvl = Level.SEVERE;
        }
        LogRecord lr = new LogRecord(lvl, "Exception thrown at " + thrownAt + ":\r\n" + Exceptions.getStackTrace(e));
        lr.setLoggerName(this.getName());
        this.log(lr);
        if (this.isAutoFlushOnThrowable()) {
            this.flush();
        }
    }

    public void logAsynch(InputStream is) {
        new InputStreamLogger(is, this).start();
    }

    public void setAllowTimeoutFlush(boolean allowTimeoutFlush) {
        this.allowTimeoutFlush = allowTimeoutFlush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentThreadLogSource() {
        WeakHashMap<Thread, WeakReference<LogSource>> weakHashMap = LASTTHREADLOGSOURCE;
        synchronized (weakHashMap) {
            Thread thread = Thread.currentThread();
            WeakReference<LogSource> prevLogSource = LASTTHREADLOGSOURCE.get(thread);
            if (prevLogSource == null || prevLogSource.get() != this) {
                LASTTHREADLOGSOURCE.put(Thread.currentThread(), new WeakReference<LogSource>(this));
            }
        }
    }

    public void setFlushOnFinalize(boolean flushOnFinalize) {
        this.flushOnFinalize = flushOnFinalize;
    }

    public void setInstantFlush(boolean instantFlush) {
        if (this.instantFlush == instantFlush) {
            return;
        }
        this.instantFlush = instantFlush;
        if (instantFlush) {
            this.flush();
        }
    }

    public synchronized void setMaxLogRecordsInMemory(int newMax) {
        if (this.maxLogRecordsInMemory == (newMax = Math.max(0, newMax))) {
            return;
        }
        this.maxLogRecordsInMemory = newMax;
        if (newMax == 0 || newMax <= this.records.size()) {
            this.flush();
        }
    }

    public synchronized void setMaxSizeInMemory(int maxSizeInMemory) {
        if (this.maxSizeInMemory == (maxSizeInMemory = Math.max(0, maxSizeInMemory))) {
            return;
        }
        this.maxSizeInMemory = maxSizeInMemory;
        if (maxSizeInMemory == 0 || maxSizeInMemory <= this.currentSizeInMemory) {
            this.flush();
        }
    }

    public LogSink getLogSink() {
        Logger parent = this.parent;
        if (parent instanceof LogSink) {
            return (LogSink)parent;
        }
        return null;
    }

    @Override
    public void setParent(Logger parent) {
        this.parent = parent;
    }

    @Override
    public void setUseParentHandlers(boolean useParentHandlers) {
    }

    public String toString() {
        return this.toString(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(int lastXEntries) {
        StringBuilder sb = new StringBuilder();
        LogSource logSource = this;
        synchronized (logSource) {
            sb.append("Log:" + this.getName() + "|Records:" + this.recordsCounter + "|Cached:" + (this.records != null ? this.currentSizeInMemory + "/" + this.records.size() : "0") + "|Flushed:" + this.flushCounter);
            if (this.records != null && this.records.size() > 0) {
                sb.append("\r\n");
                LogSourceFormatter formatter = new LogSourceFormatter();
                formatter.setFormatterStringBuilder(sb);
                int index = 0;
                if (lastXEntries > 0 && this.records.size() > lastXEntries) {
                    index = this.records.size() - lastXEntries;
                }
                while (index < this.records.size()) {
                    sb.append(formatter.format(this.records.get(index)));
                    ++index;
                }
            }
        }
        return sb.toString();
    }

    @Override
    public void exception(String msg, Throwable e) {
        this.severe(msg);
        this.log(e);
    }
}

