/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging2;

import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.RequiresRestart;
import org.appwork.storage.config.annotations.SpinnerValidator;

public interface LogConfig
extends ConfigInterface {
    @AboutConfig
    @DefaultIntValue(value=2)
    @SpinnerValidator(min=0L, max=0x7FFFFFFFL)
    @DescriptionForConfigEntry(value="Automatic remove logs older than x days")
    @RequiresRestart(value="A JDownloader Restart is Required")
    public int getCleanupLogsOlderThanXDays();

    @AboutConfig
    @DefaultIntValue(value=60)
    @SpinnerValidator(min=30L, max=0x7FFFFFFFL)
    @DescriptionForConfigEntry(value="Timeout in secs after which the logger will be flushed/closed")
    @RequiresRestart(value="A JDownloader Restart is Required")
    public int getLogFlushTimeout();

    @AboutConfig
    @DefaultIntValue(value=5)
    @SpinnerValidator(min=1L, max=0x7FFFFFFFL)
    @DescriptionForConfigEntry(value="Max number of logfiles for each logger")
    @RequiresRestart(value="A JDownloader Restart is Required")
    public int getMaxLogFiles();

    @AboutConfig
    @DefaultIntValue(value=0xA00000)
    @SpinnerValidator(min=0L, max=0x7FFFFFFFL)
    @DescriptionForConfigEntry(value="Max logfile size in bytes. Size <100Kbyte will disable logfiles")
    @RequiresRestart(value="A JDownloader Restart is Required")
    public int getMaxLogFileSize();

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Enable debug mode, nearly everything will be logged!")
    @RequiresRestart(value="A JDownloader Restart is Required")
    public boolean isDebugModeEnabled();

    public void setCleanupLogsOlderThanXDays(int var1);

    public void setDebugModeEnabled(boolean var1);

    public void setLogFlushTimeout(int var1);

    public void setMaxLogFiles(int var1);

    public void setMaxLogFileSize(int var1);
}

