/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.appwork.utils.logging2.LogSource;

public class InputStreamLogger
extends Thread {
    private InputStream stream;
    private LogSource logger;

    public InputStreamLogger(InputStream is, LogSource logSource) {
        this.stream = is;
        this.logger = logSource;
    }

    @Override
    public void run() {
        try {
            this.readInputStreamToString(this.stream, this.logger);
        }
        catch (Exception e) {
            this.logger.log(e);
        }
    }

    public void readInputStreamToString(InputStream fis, LogSource logger) throws UnsupportedEncodingException, IOException, InterruptedException {
        BufferedReader f = null;
        try {
            String line;
            f = new BufferedReader(new InputStreamReader(fis, "UTF8"));
            while ((line = f.readLine()) != null) {
                if (line.startsWith("\ufeff")) {
                    line = line.substring(1);
                }
                logger.info(line);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
    }
}

