/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.Application;

public class LogToFileHandler
extends Handler {
    private volatile File file;
    private BufferedWriter writer;
    private OutputStreamWriter osw = null;
    private FileOutputStream fos = null;

    public LogToFileHandler() throws IOException {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(new Date().getTime());
        this.file = Application.getResource("logs/" + cal.get(1) + "-" + (1 + cal.get(2)) + "-" + cal.get(5) + ".log");
        this.file.getParentFile().mkdirs();
        this.file.deleteOnExit();
        if (!this.file.isFile()) {
            this.file.createNewFile();
        }
        try {
            this.fos = new FileOutputStream(this.file, true);
            this.osw = new OutputStreamWriter((OutputStream)this.fos, "UTF8");
            this.writer = new BufferedWriter(this.osw);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.writer = null;
        }
        try {
            if (this.osw != null) {
                this.osw.close();
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.osw = null;
        }
        try {
            if (this.fos != null) {
                this.fos.close();
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.fos = null;
        }
        File lfile = this.file;
        this.file = null;
        if (lfile != null && lfile.exists() && lfile.length() == 0L) {
            lfile.delete();
        }
    }

    @Override
    public void flush() {
        try {
            BufferedWriter lwriter = this.writer;
            if (lwriter != null) {
                lwriter.flush();
            }
        }
        catch (IOException e) {
            LogV3.log(e);
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (logRecord.getLevel() == Level.INFO) {
            try {
                BufferedWriter lwriter = this.writer;
                if (lwriter != null) {
                    lwriter.write(this.getFormatter().format(logRecord));
                }
            }
            catch (IOException e) {
                if (e.getMessage().contains("not enough")) {
                    LogV3.severe("Cannot write log, Disk is full!");
                }
                LogV3.log(e);
            }
        }
    }
}

