/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.appwork.utils.Application;

public class ExceptionLogHandler
extends Handler {
    private File file;
    private BufferedWriter writer = null;
    private OutputStreamWriter osw = null;
    private FileOutputStream fos = null;

    public ExceptionLogHandler() {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(new Date().getTime());
            this.file = Application.getResource("logs/error_" + cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5) + "-" + System.currentTimeMillis() + ".log");
            this.file.getParentFile().mkdirs();
            this.file.deleteOnExit();
            if (!this.file.isFile()) {
                this.file.createNewFile();
            }
            this.fos = new FileOutputStream(this.file, true);
            this.osw = new OutputStreamWriter((OutputStream)this.fos, "UTF8");
            this.writer = new BufferedWriter(this.osw);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.close();
        }
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.writer = null;
        }
        try {
            this.osw.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.fos.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void flush() {
        try {
            if (this.writer == null) {
                return;
            }
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void publish(LogRecord logRecord) {
        try {
            if (this.writer == null) {
                return;
            }
            this.writer.write(this.getFormatter().format(logRecord));
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

