/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.io.streamingio;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.Regex;
import org.appwork.utils.io.streamingio.StreamingChunk;
import org.appwork.utils.io.streamingio.StreamingInputStream;
import org.appwork.utils.io.streamingio.StreamingOutputStream;
import org.appwork.utils.io.streamingio.StreamingOverlapWrite;

public abstract class Streaming {
    protected List<StreamingChunk> availableChunks = new ArrayList<StreamingChunk>();
    protected List<WeakReference<StreamingInputStream>> connectedInputStreams = new ArrayList<WeakReference<StreamingInputStream>>();
    protected List<WeakReference<StreamingOutputStream>> connectedOutputStreams = new ArrayList<WeakReference<StreamingOutputStream>>();
    protected final String outputFile;
    private boolean isClosed = false;
    private final Comparator<StreamingChunk> comparator = new Comparator<StreamingChunk>(){

        @Override
        public int compare(StreamingChunk o1, StreamingChunk o2) {
            long y;
            long x = o1.getChunkStartPosition();
            return x < (y = o2.getChunkStartPosition()) ? 1 : (x == y ? 0 : -1);
        }
    };

    public Streaming(String outputFile) throws IOException {
        this.outputFile = outputFile;
        final String outputFilename = new File(outputFile).getName();
        File[] foundChunks = new File(outputFile).getParentFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().startsWith(outputFilename) && new Regex(pathname.getName(), "\\.chk\\d+$").matches();
            }
        });
        if (foundChunks != null) {
            for (File chunk : foundChunks) {
                String startPosition = new Regex(chunk.getName(), "\\.chk(\\d+)$").getMatch(0);
                this.availableChunks.add(new StreamingChunk(chunk, Long.parseLong(startPosition)));
            }
            Collections.sort(this.availableChunks, this.comparator);
        }
    }

    public synchronized void close() {
        Closeable current;
        WeakReference<Closeable> next;
        Iterator<WeakReference<Closeable>> it2;
        this.isClosed = true;
        try {
            it2 = this.connectedInputStreams.iterator();
            while (it2.hasNext()) {
                next = it2.next();
                current = (StreamingInputStream)next.get();
                it2.remove();
                if (current == null) continue;
                ((StreamingInputStream)current).setCurrentChunk(null);
            }
        }
        catch (Throwable it2) {
            // empty catch block
        }
        try {
            it2 = this.connectedOutputStreams.iterator();
            while (it2.hasNext()) {
                next = it2.next();
                current = (StreamingOutputStream)next.get();
                it2.remove();
                if (current == null) continue;
                ((StreamingOutputStream)current).setCurrentChunk(null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            for (StreamingChunk chunk : this.availableChunks) {
                try {
                    chunk.close();
                }
                catch (Throwable throwable) {}
            }
            this.availableChunks.clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void closeInputStream(StreamingInputStream streamingInputStream) {
        try {
            Iterator<WeakReference<StreamingInputStream>> it = this.connectedInputStreams.iterator();
            while (it.hasNext()) {
                StreamingInputStream current = null;
                WeakReference<StreamingInputStream> next = it.next();
                current = (StreamingInputStream)next.get();
                if (current != null && current != streamingInputStream) continue;
                it.remove();
            }
        }
        finally {
            streamingInputStream.setCurrentChunk(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void closeOutputStream(StreamingOutputStream streamingOutputStream) {
        try {
            Iterator<WeakReference<StreamingOutputStream>> it = this.connectedOutputStreams.iterator();
            while (it.hasNext()) {
                StreamingOutputStream current = null;
                WeakReference<StreamingOutputStream> next = it.next();
                current = (StreamingOutputStream)next.get();
                if (current != null && current != streamingOutputStream) continue;
                it.remove();
            }
        }
        finally {
            StreamingChunk currentChunk = streamingOutputStream.getCurrentChunk();
            if (currentChunk != null) {
                currentChunk.setCanGrow(false);
            }
            streamingOutputStream.setCurrentChunk(null);
        }
    }

    protected boolean connectStreamingOutputStream(StreamingChunk streamingChunk, long startPosition, long endPosition) throws IOException {
        StreamingOutputStream streamingOutputStream = this.streamingOutputStreamFactory();
        streamingOutputStream.setCurrentChunk(streamingChunk);
        if (!this.connectStreamingOutputStream(streamingOutputStream, startPosition, endPosition)) {
            return false;
        }
        this.connectedOutputStreams.add(new WeakReference<StreamingOutputStream>(streamingOutputStream));
        streamingChunk.setCanGrow(true);
        return true;
    }

    public abstract boolean connectStreamingOutputStream(StreamingOutputStream var1, long var2, long var4) throws IOException;

    protected synchronized void detectOverlappingChunks(StreamingChunk currentChunk) throws IOException {
        StreamingChunk overlapChunk;
        long overlapCheck = currentChunk.getChunkStartPosition() + currentChunk.getAvailableChunkSize();
        int chunkIndex = this.availableChunks.indexOf(currentChunk);
        if (chunkIndex >= 1 && overlapCheck > (overlapChunk = this.availableChunks.get(chunkIndex - 1)).getChunkStartPosition()) {
            throw new StreamingOverlapWrite();
        }
    }

    protected synchronized List<StreamingInputStream> findAllStreamingInputStreamsFor(StreamingOutputStream streamingOutputStream) {
        StreamingChunk chunk = streamingOutputStream.getCurrentChunk();
        ArrayList<StreamingInputStream> ret = new ArrayList<StreamingInputStream>();
        if (chunk != null) {
            for (WeakReference<StreamingInputStream> next : this.connectedInputStreams) {
                StreamingInputStream current = (StreamingInputStream)next.get();
                if (current == null || current.getCurrentChunk() != chunk) continue;
                ret.add(current);
            }
        }
        return null;
    }

    protected synchronized StreamingOutputStream findLastStreamingOutputStreamFor(StreamingInputStream streamingInputStream) {
        StreamingChunk chunk = streamingInputStream.getCurrentChunk();
        if (chunk != null) {
            for (WeakReference<StreamingOutputStream> next : this.connectedOutputStreams) {
                StreamingOutputStream current = (StreamingOutputStream)next.get();
                if (current == null || current.getCurrentChunk() != chunk) continue;
                return current;
            }
        }
        return null;
    }

    public abstract long getFinalFileSize();

    public synchronized StreamingInputStream getInputStream(long startPosition, long endPosition) throws IOException {
        if (this.isClosed) {
            throw new IOException("streaming file is closed!");
        }
        if (startPosition < 0L) {
            throw new IllegalArgumentException("startPosition <0");
        }
        if (endPosition >= 0L && endPosition <= startPosition) {
            throw new IllegalArgumentException("endposition <= startPosition");
        }
        if (this.getFinalFileSize() > 0L && startPosition >= this.getFinalFileSize()) {
            throw new IllegalArgumentException("startPosition >= filesize");
        }
        StreamingInputStream streamingInputStream = this.streamingInputStreamFactory(startPosition, endPosition);
        StreamingChunk streamingChunk = this.getNextStreamingChunk(startPosition, endPosition);
        if (streamingChunk == null) {
            throw new IOException("no inputStream for requested range available");
        }
        streamingInputStream.setCurrentChunk(streamingChunk);
        this.connectedInputStreams.add(new WeakReference<StreamingInputStream>(streamingInputStream));
        return streamingInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized StreamingChunk getNextStreamingChunk(long startPosition, long endPosition) throws IOException {
        if (this.isClosed()) {
            return null;
        }
        if (this.getFinalFileSize() > 0L && startPosition >= this.getFinalFileSize()) {
            return null;
        }
        StreamingChunk streamingChunk = null;
        boolean need2ConnectStreamingOutputStream = false;
        for (StreamingChunk chunk : this.availableChunks) {
            if (chunk.getChunkStartPosition() > startPosition) continue;
            if (chunk.getChunkStartPosition() + chunk.getAvailableChunkSize() > startPosition) {
                streamingChunk = chunk;
                break;
            }
            if (chunk.getChunkStartPosition() + chunk.getAvailableChunkSize() != startPosition) continue;
            streamingChunk = chunk;
            if (chunk.canGrow()) break;
            need2ConnectStreamingOutputStream = true;
            break;
        }
        if (streamingChunk == null) {
            File chunkFile = new File(this.outputFile + ".chk" + startPosition);
            try {
                streamingChunk = new StreamingChunk(chunkFile, startPosition);
                if (!this.connectStreamingOutputStream(streamingChunk, startPosition, endPosition)) {
                    return null;
                }
            }
            catch (IOException e) {
                try {
                    streamingChunk.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    chunkFile.delete();
                }
                throw e;
            }
            this.availableChunks.add(streamingChunk);
            Collections.sort(this.availableChunks, this.comparator);
        }
        if (need2ConnectStreamingOutputStream && !this.connectStreamingOutputStream(streamingChunk, startPosition, endPosition)) {
            return null;
        }
        return streamingChunk;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    protected int readChunkData(StreamingInputStream streamingInputStream, byte[] b, int off, int len) throws IOException {
        if (this.isClosed()) {
            return -1;
        }
        StreamingChunk currentChunk = streamingInputStream.getCurrentChunk();
        try {
            while (true) {
                int ret;
                if ((ret = currentChunk.read(b, off, len, streamingInputStream.getCurrentPosition())) > 0) {
                    return ret;
                }
                if (ret != -1) break;
                currentChunk = this.getNextStreamingChunk(streamingInputStream.getCurrentPosition(), streamingInputStream.getEndPosition());
                if (currentChunk == null) {
                    return -1;
                }
                streamingInputStream.setCurrentChunk(currentChunk);
            }
            throw new WTFException("How could this happen?!");
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    protected StreamingInputStream streamingInputStreamFactory(long startPosition, long endPosition) {
        return new StreamingInputStream(this, startPosition, endPosition);
    }

    protected StreamingOutputStream streamingOutputStreamFactory() {
        return new StreamingOutputStream(this);
    }

    protected void writeChunkData(StreamingOutputStream streamingOutputStream, byte[] b, int off, int len) throws IOException {
        StreamingChunk currentChunk = streamingOutputStream.getCurrentChunk();
        currentChunk.write(b, off, len);
        if (this.isClosed()) {
            throw new IOException("closed");
        }
        this.detectOverlappingChunks(currentChunk);
    }
}

