/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.io;

import com.sun.nio.file.ExtendedWatchEventModifier;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.Application;
import org.appwork.utils.Hash;

public abstract class J7FileObserver
implements Runnable {
    private Thread runner;
    private final String filename;
    private final String hash;
    private List<WatchKey> keys;

    public static void main(String[] s) throws IOException, InterruptedException {
        J7FileObserver o = new J7FileObserver("file.txt", null){

            @Override
            public void onFound(File file) {
                System.out.println("Found " + file);
            }
        };
        o.start();
        Thread.sleep(150000L);
        o.stop();
    }

    public J7FileObserver(String name, String hash) {
        this.filename = name;
        this.hash = hash;
        if (Application.getJavaVersion() < Application.JAVA17) {
            throw new IllegalStateException("This Class is Java 1.7 and Windows only");
        }
    }

    public abstract void onFound(File var1);

    @Override
    public void run() {
        this.keys = new ArrayList<WatchKey>();
        try {
            WatchService watcher = FileSystems.getDefault().newWatchService();
            for (Path next : FileSystems.getDefault().getRootDirectories()) {
                try {
                    this.keys.add(next.register(watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE}, ExtendedWatchEventModifier.FILE_TREE));
                }
                catch (Throwable throwable) {}
            }
            block9: while (true) {
                WatchKey key;
                try {
                    key = watcher.take();
                }
                catch (InterruptedException x) {
                    return;
                }
                Iterator<WatchEvent<?>> iterator = key.pollEvents().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block9;
                    WatchEvent<?> event = iterator.next();
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    WatchEvent<?> ev = event;
                    Path filename = (Path)ev.context();
                    Path abp = ((Path)key.watchable()).resolve(filename);
                    if (abp.getFileName().toString().equals(this.filename)) {
                        for (int i = 0; i < 5; ++i) {
                            String localHash = Hash.getMD5(abp.toFile());
                            if (localHash == null && this.hash != null) {
                                try {
                                    Thread.sleep(200L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                continue;
                            }
                            System.out.println(this.hash + " - " + localHash);
                            if (this.hash != null && !this.hash.equals(localHash)) continue;
                            this.onFound(abp.toFile());
                            return;
                        }
                    }
                    if (key.reset()) continue;
                    System.out.println("Key " + key + " is invalid" + key.watchable());
                }
                break;
            }
        }
        catch (IOException e) {
            LogV3.log(e);
            return;
        }
    }

    public void start() {
        if (this.runner != null) {
            throw new IllegalStateException("Already running");
        }
        this.runner = new Thread(this);
        this.runner.start();
    }

    public void stop() {
        if (this.runner != null) {
            this.runner.interrupt();
            this.runner = null;
        }
        for (WatchKey w : this.keys) {
            w.cancel();
        }
    }
}

