/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.images.svg;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.Regex;
import org.appwork.utils.images.ScalableIcon;
import org.appwork.utils.images.svg.SVGFactory;
import org.appwork.utils.images.svg.SVGIcon;

public class SVGIO {
    private final SVGFactory factory;

    public SVGIO(SVGFactory factory) {
        this.factory = factory;
    }

    public Image getImageFromSVG(URI uri, int w, int h) throws IOException {
        return this.getImageFromSVG(uri, w, h, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image getImageFromSVG(URI uri, int w, int h, Color color) throws IOException {
        try {
            InputStream is = null;
            try {
                is = this.factory.openInputStream(uri);
                if (is == null) throw new IOException("Not found:" + uri);
                Image image = this.getImageFromSVG(is, uri, w, h, color);
                return image;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException("URL:" + uri, e);
        }
    }

    protected String getName(URI uri) {
        String uriName;
        if (uri != null && uri.getPath() != null && (uriName = new Regex(uri.getPath(), "/([^/]*?\\.svg)$").getMatch(0)) != null) {
            return uriName;
        }
        return "dummy.svg";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImageFromSVG(InputStream is, URI base, int w, int h, Color color) throws IOException {
        try {
            SVGUniverse universe = new SVGUniverse();
            URI uri = universe.loadSVG(is, this.getName(base));
            SVGDiagram diagram = universe.getDiagram(uri);
            if (diagram == null) {
                return null;
            }
            diagram.updateTime(0.0);
            diagram.setIgnoringClipHeuristic(true);
            if (w <= 0) {
                w = (int)diagram.getWidth();
            }
            if (h <= 0) {
                h = (int)diagram.getHeight();
            }
            double faktor = 1.0 / Math.max((double)diagram.getWidth() / (double)w, (double)diagram.getHeight() / (double)h);
            int width = Math.max((int)((double)diagram.getWidth() * faktor), 1);
            int height = Math.max((int)((double)diagram.getHeight() * faktor), 1);
            BufferedImage bi = new BufferedImage(width, height, 6);
            Graphics2D g = bi.createGraphics();
            try {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                int x = 0;
                int y = 0;
                g.translate(x, y);
                Rectangle2D.Double rect = new Rectangle2D.Double();
                diagram.getViewRect((Rectangle2D)rect);
                AffineTransform scaleXform = new AffineTransform();
                scaleXform.setToScale((double)width / rect.width, (double)height / rect.height);
                g.transform(scaleXform);
                diagram.render(g);
            }
            finally {
                g.dispose();
            }
            return bi;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public ScalableIcon getIconFromSVG(InputStream stream, URI base, int width, int height, Color color) throws IOException {
        SVGUniverse universe = new SVGUniverse();
        try {
            URI uri = universe.loadSVG(stream, this.getName(base));
            final SVGDiagram diagram = universe.getDiagram(uri);
            if (diagram == null) {
                return null;
            }
            diagram.updateTime(0.0);
            diagram.setIgnoringClipHeuristic(true);
            return new SVGIcon(width, height){

                @Override
                public int getIconHeight() {
                    this.ensureDimensions();
                    return super.getIconHeight();
                }

                private void ensureDimensions() {
                    if (super.getIconWidth() <= 0) {
                        this.setIconWidth((int)diagram.getWidth());
                    }
                    if (super.getIconHeight() <= 0) {
                        this.setIconHeight((int)diagram.getHeight());
                    }
                }

                @Override
                public int getIconWidth() {
                    this.ensureDimensions();
                    return super.getIconWidth();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void paintIcon(Component c, Graphics g1D, int x, int y, int width, int height) {
                    if (width <= 0) {
                        width = (int)diagram.getWidth();
                    }
                    if (height <= 0) {
                        height = (int)diagram.getHeight();
                    }
                    double faktor = 1.0 / Math.max((double)diagram.getWidth() / (double)width, (double)diagram.getHeight() / (double)height);
                    width = Math.max((int)((double)diagram.getWidth() * faktor), 1);
                    height = Math.max((int)((double)diagram.getHeight() * faktor), 1);
                    Graphics2D g = (Graphics2D)g1D;
                    RenderingHints restoreHints = g.getRenderingHints();
                    AffineTransform restoreTransform = g.getTransform();
                    try {
                        g.translate(x, y);
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        Rectangle2D.Double rect = new Rectangle2D.Double();
                        diagram.getViewRect((Rectangle2D)rect);
                        g.scale((double)width / rect.width, (double)height / rect.height);
                        try {
                            diagram.render(g);
                        }
                        catch (SVGException e) {
                            throw new WTFException(e);
                        }
                    }
                    finally {
                        g.setRenderingHints(restoreHints);
                        g.setTransform(restoreTransform);
                    }
                }
            };
        }
        catch (SVGElementException e) {
            throw new IOException(e);
        }
        catch (SVGException e1) {
            throw new IOException(e1);
        }
    }
}

