/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.formatter;

import java.nio.ByteBuffer;

public class HexFormatter {
    public static String byteArrayToHex(byte[] digest) {
        return HexFormatter.toHex(digest, new StringBuilder()).toString();
    }

    public static StringBuilder toHex(byte[] input, StringBuilder output) {
        output.ensureCapacity(output.capacity() + input.length * 2);
        for (byte d : input) {
            String tmp = Integer.toHexString(d & 0xFF);
            if (tmp.length() < 2) {
                output.append('0');
            }
            output.append(tmp);
        }
        return output;
    }

    public static StringBuilder toHex(ByteBuffer digest, StringBuilder output) {
        output.ensureCapacity(output.capacity() + digest.remaining() * 2);
        while (digest.hasRemaining()) {
            byte b = digest.get();
            String tmp = Integer.toHexString(b & 0xFF);
            if (tmp.length() < 2) {
                output.append('0');
            }
            output.append(tmp);
        }
        return output;
    }

    public static String byteBufferToHex(ByteBuffer digest) {
        return HexFormatter.toHex(digest, new StringBuilder()).toString();
    }

    public static byte[] hexToByteArray(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }
}

