/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.event.queue;

import org.appwork.loggingv3.LogV3;
import org.appwork.utils.event.queue.Queue;

public abstract class QueueAction<T, E extends Throwable> {
    private Throwable exeption;
    private volatile boolean finished = false;
    private volatile boolean killed = false;
    private Queue.QueuePriority prio = Queue.QueuePriority.NORM;
    private Queue queue = null;
    private T result = null;
    private String callerStackTrace = null;
    private volatile boolean started = false;
    private Thread thread = null;

    public QueueAction() {
    }

    public QueueAction(Queue.QueuePriority prio) {
        this.prio = prio;
    }

    protected boolean allowAsync() {
        return false;
    }

    protected synchronized boolean callExceptionHandler() {
        if (this.exeption == null) {
            return true;
        }
        if (this.exeption != null && this.handleException(this.exeption)) {
            this.exeption = null;
            return true;
        }
        return false;
    }

    protected String getCallerStackTrace() {
        return this.callerStackTrace;
    }

    protected Thread getCallerThread() {
        return this.thread;
    }

    public Throwable getExeption() {
        return this.exeption;
    }

    protected Queue getQueue() {
        return this.queue;
    }

    public Queue.QueuePriority getQueuePrio() {
        return this.prio;
    }

    public T getResult() {
        return this.result;
    }

    public boolean gotKilled() {
        return this.killed;
    }

    public boolean gotStarted() {
        return this.started;
    }

    public boolean handleException(Throwable e) {
        LogV3.log(e);
        return false;
    }

    public boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean kill() {
        QueueAction queueAction = this;
        synchronized (queueAction) {
            if (this.finished) {
                return false;
            }
            this.killed = true;
            this.finished = true;
            this.notifyAll();
            return true;
        }
    }

    protected void onEnqueu(Queue queue) {
    }

    protected void postRun() {
    }

    protected void preRun() {
    }

    public void reset() {
        this.exeption = null;
        this.killed = false;
        this.finished = false;
        this.callerStackTrace = null;
        this.thread = null;
        this.queue = null;
    }

    protected abstract T run() throws E;

    public void setCallerThread(Queue queue, Thread thread) {
        this.thread = thread;
        this.queue = queue;
        if (queue != null && queue.isDebug() && thread != null) {
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement elem : thread.getStackTrace()) {
                sb.append(elem.toString() + "\r\n");
            }
            this.callerStackTrace = sb.toString();
            Object var3_3 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFinished(boolean finished) {
        QueueAction queueAction = this;
        synchronized (queueAction) {
            this.finished = finished;
            this.notifyAll();
        }
    }

    public void setQueuePrio(Queue.QueuePriority prio) {
        this.prio = prio;
    }

    public final void start(Queue queue) throws E {
        this.queue = queue;
        this.started = true;
        try {
            this.preRun();
        }
        catch (Throwable e) {
            LogV3.log(e);
        }
        try {
            this.result = this.run();
        }
        catch (Throwable th) {
            if (queue != null && queue.isDebug()) {
                LogV3.severe("QueueActionCallerStackTrace:\r\n" + this.callerStackTrace);
            }
            this.exeption = th;
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw th;
        }
        finally {
            try {
                this.postRun();
            }
            catch (Throwable e) {
                LogV3.log(e);
            }
        }
    }
}

