/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.encoding;

import java.io.UnsupportedEncodingException;

public class Hex {
    public static byte[] hex2ByteArray(CharSequence hexString) {
        if (hexString == null) {
            return null;
        }
        int length = hexString.length();
        byte[] buffer = new byte[(length + 1) / 2];
        boolean evenByte = true;
        byte nextByte = 0;
        int bufferOffset = 0;
        if (length % 2 == 1) {
            evenByte = false;
        }
        for (int i = 0; i < length; ++i) {
            int nibble;
            char c = hexString.charAt(i);
            if (c >= '0' && c <= '9') {
                nibble = c - 48;
            } else if (c >= 'A' && c <= 'F') {
                nibble = c - 65 + 10;
            } else if (c >= 'a' && c <= 'f') {
                nibble = c - 97 + 10;
            } else {
                throw new NumberFormatException("Invalid hex digit '" + c + "'.");
            }
            if (evenByte) {
                nextByte = (byte)(nibble << 4);
            } else {
                nextByte = (byte)(nextByte + (byte)nibble);
                buffer[bufferOffset++] = nextByte;
            }
            evenByte = !evenByte;
        }
        return buffer;
    }

    public static String hex2String(CharSequence hexString) {
        if (hexString == null) {
            return null;
        }
        try {
            return new String(Hex.hex2ByteArray(hexString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(Hex.hex2ByteArray(hexString));
        }
    }

    private Hex() {
    }
}

