/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.duration;

import java.math.BigDecimal;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.Time;
import org.appwork.utils.duration.ContextMissingException;
import org.appwork.utils.duration.InvalidTimeSpanException;
import org.appwork.utils.duration.TimeSpan;
import org.appwork.utils.duration.Unit;

public class TimeSpanWithContext
extends TimeSpan {
    protected TimeSpanWithContext() {
    }

    @Override
    public BigDecimal getBigDecimal(Unit targetUnit) {
        try {
            return super.getBigDecimal(targetUnit);
        }
        catch (ContextMissingException e) {
            throw new WTFException(e);
        }
    }

    @Override
    public TimeSpanWithContext withZero(Unit ... units) {
        return (TimeSpanWithContext)super.withZero(units);
    }

    @Override
    public long getLong(Unit targetUnit) {
        try {
            return super.getLong(targetUnit);
        }
        catch (ContextMissingException e) {
            throw new WTFException(e);
        }
    }

    @Override
    public TimeSpanWithContext normalized() {
        return (TimeSpanWithContext)super.normalized();
    }

    @Override
    public boolean isLessThan(long milliseconds) {
        return this.getBigDecimal(Unit.MILLISECONDS).longValue() < milliseconds;
    }

    @Override
    public TimeSpanWithContext limit(TimeSpan min, TimeSpan max) {
        return (TimeSpanWithContext)super.limit(min, max);
    }

    @Override
    protected TimeSpanWithContext copy() {
        TimeSpanWithContext ret = new TimeSpanWithContext();
        this.fillClone(ret);
        return ret;
    }

    @Override
    public boolean hasContext() {
        return true;
    }

    @Override
    public TimeSpanWithContext setDays(int days) throws InvalidTimeSpanException {
        return (TimeSpanWithContext)super.setDays(days);
    }

    @Override
    public TimeSpanWithContext setHours(int hours) throws InvalidTimeSpanException {
        return (TimeSpanWithContext)super.setHours(hours);
    }

    @Override
    public TimeSpanWithContext setMicroseconds(int microseconds) throws InvalidTimeSpanException {
        return (TimeSpanWithContext)super.setMicroseconds(microseconds);
    }

    @Override
    public TimeSpanWithContext setMilliseconds(int milliseconds) throws InvalidTimeSpanException {
        return (TimeSpanWithContext)super.setMilliseconds(milliseconds);
    }

    @Override
    public TimeSpanWithContext setMinutes(int minutes) throws InvalidTimeSpanException {
        return (TimeSpanWithContext)super.setMinutes(minutes);
    }

    @Override
    public TimeSpanWithContext setMonths(int months) throws InvalidTimeSpanException {
        return (TimeSpanWithContext)super.setMonths(months);
    }

    @Override
    public TimeSpanWithContext setNanoseconds(int nanoseconds) throws InvalidTimeSpanException {
        return (TimeSpanWithContext)super.setNanoseconds(nanoseconds);
    }

    @Override
    public TimeSpanWithContext setSeconds(int seconds) throws InvalidTimeSpanException {
        return (TimeSpanWithContext)super.setSeconds(seconds);
    }

    @Override
    public TimeSpanWithContext setWeeks(int weeks) throws InvalidTimeSpanException {
        return (TimeSpanWithContext)super.setWeeks(weeks);
    }

    @Override
    public TimeSpanWithContext setYears(int years) throws InvalidTimeSpanException {
        return (TimeSpanWithContext)super.setYears(years);
    }

    public long getExpiresAtEpochMillis() {
        return this.getContextEpochMillis() + this.getLong(Unit.MILLISECONDS);
    }

    public boolean isExpired() {
        return Time.timestamp() > this.getExpiresAtEpochMillis();
    }
}

