/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.crypto;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.appwork.loggingv3.LogV3;

public class Crypto {
    private static final String CHAR_POOL = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!\"\u00a7$%&/()=?{[]}\\'#*+~,.-;:_'";

    public static String decrypt(byte[] b, byte[] key) {
        return Crypto.decrypt(b, key, key);
    }

    public static String decrypt(byte[] b, byte[] key, byte[] iv) {
        byte[] ret = Crypto.decryptAsByteArray(b, key, iv);
        if (ret != null) {
            try {
                return new String(ret, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LogV3.log(e);
            }
        }
        return null;
    }

    protected static byte[] decryptAsByteArray(byte[] b, byte[] key, byte[] iv) {
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)skeySpec, ivSpec);
            return cipher.doFinal(b);
        }
        catch (Exception e) {
            LogV3.log(e);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
            try {
                Cipher cipher = Cipher.getInstance("AES/CBC/nopadding");
                cipher.init(2, (Key)skeySpec, ivSpec);
                cipher.doFinal(b);
            }
            catch (Exception e1) {
                LogV3.log(e1);
            }
            return null;
        }
    }

    public static byte[] encrypt(String string, byte[] key, byte[] iv) {
        try {
            return Crypto.encryptByteArray(string.getBytes("UTF-8"), key, iv);
        }
        catch (Exception e) {
            LogV3.log(e);
            return null;
        }
    }

    protected static byte[] encryptByteArray(byte[] data, byte[] key, byte[] iv) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        cipher.init(1, (Key)skeySpec, ivSpec);
        return cipher.doFinal(data);
    }

    public static String generateRandomString(int length) {
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder stringBuilder = new StringBuilder(length);
        int poolSize = CHAR_POOL.length();
        for (int i = 0; i < length; ++i) {
            int randomIndex = secureRandom.nextInt(poolSize);
            stringBuilder.append(CHAR_POOL.charAt(randomIndex));
        }
        return stringBuilder.toString();
    }
}

