/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.DebugMode;
import org.appwork.utils.crypto.SignatureViolationException;
import org.appwork.utils.encoding.Base64;

public class AWSign {
    private static SecureRandom sr;

    public static KeyPair createKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        System.out.println("PUBLIC  " + Base64.encodeToString(keyPair.getPublic().getEncoded(), false));
        System.out.println("PRIVATE " + Base64.encodeToString(keyPair.getPrivate().getEncoded(), false));
        return keyPair;
    }

    public static byte[] createSign(byte[] bytes, PrivateKey pk, boolean salt) throws SignatureViolationException {
        return AWSign.createSign(bytes, pk, salt, null);
    }

    public static byte[] createSign(byte[] bytes, PrivateKey pk, boolean salt, byte[] addInfo) throws SignatureViolationException {
        try {
            Signature sig = Signature.getInstance("Sha256WithRSA");
            sig.initSign(pk);
            byte[] saltBytes = AWSign.get16ByteSalt(salt);
            if (saltBytes != null) {
                sig.update(saltBytes);
            }
            if (addInfo != null) {
                sig.update(addInfo, 0, addInfo.length);
            }
            sig.update(bytes, 0, bytes.length);
            byte[] ret = sig.sign();
            if (!salt) {
                return ret;
            }
            byte[] merged = new byte[ret.length + saltBytes.length];
            System.arraycopy(saltBytes, 0, merged, 0, saltBytes.length);
            System.arraycopy(ret, 0, merged, saltBytes.length, ret.length);
            return merged;
        }
        catch (Throwable e) {
            throw new SignatureViolationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] createSign(File f, PrivateKey publicKey, boolean salt, byte[] addInfo) throws SignatureViolationException {
        try {
            Signature sig = Signature.getInstance("Sha256WithRSA");
            sig.initSign(publicKey);
            InputStream input = null;
            try {
                int len;
                byte[] saltBytes = AWSign.get16ByteSalt(salt);
                if (saltBytes != null) {
                    sig.update(saltBytes);
                }
                if (addInfo != null) {
                    sig.update(addInfo, 0, addInfo.length);
                }
                byte[] buffer = new byte[1024];
                input = new FileInputStream(f);
                while ((len = input.read(buffer)) != -1) {
                    if (len <= 0) continue;
                    sig.update(buffer, 0, len);
                }
                byte[] ret = sig.sign();
                if (!salt) {
                    byte[] byArray = ret;
                    return byArray;
                }
                byte[] merged = new byte[ret.length + saltBytes.length];
                System.arraycopy(saltBytes, 0, merged, 0, saltBytes.length);
                System.arraycopy(ret, 0, merged, saltBytes.length, ret.length);
                byte[] byArray = merged;
                return byArray;
            }
            finally {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable e) {
            throw new SignatureViolationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decryptRSA_AES(File srcFile, File dstFile, PublicKey pk) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        boolean deleteDst = true;
        try {
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(dstFile);
            byte[] wrappedKey = new byte[256];
            byte[] wrappedIV = new byte[256];
            byte[] readDigest = new byte[32];
            int done = 0;
            int read = 0;
            while (done < 256 && (read = fis.read()) != -1) {
                wrappedKey[done++] = (byte)read;
            }
            done = 0;
            while (done < 256 && (read = fis.read()) != -1) {
                wrappedIV[done++] = (byte)read;
            }
            done = 0;
            while (done < 32 && (read = fis.read()) != -1) {
                readDigest[done++] = (byte)read;
            }
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, pk);
            SecretKeySpec key = new SecretKeySpec(cipher.doFinal(wrappedKey), "AES");
            cipher.init(2, pk);
            byte[] iv = cipher.doFinal(wrappedIV);
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)key, new IvParameterSpec(iv));
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            CipherInputStream cis = new CipherInputStream(fis, cipher);
            byte[] buffer = new byte[Short.MAX_VALUE];
            int maxReadSize = buffer.length;
            while ((read = cis.read(buffer, 0, maxReadSize)) != -1) {
                if (read <= 0) continue;
                fos.write(buffer, 0, read);
                md.update(buffer, 0, read);
            }
            byte[] generatedDigest = md.digest();
            if (!Arrays.equals(generatedDigest, readDigest)) {
                throw new IOException("Hash failed!");
            }
            fos.close();
            deleteDst = false;
        }
        finally {
            try {
                fis.close();
            }
            catch (Throwable throwable) {}
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
            if (deleteDst) {
                dstFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encryptRSA_AES(File srcFile, File dstFile, PrivateKey pk) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IOException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        boolean deleteDst = true;
        try {
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(dstFile);
            KeyGenerator keygen = KeyGenerator.getInstance("AES");
            if (sr != null) {
                keygen.init(sr);
            }
            byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            if (sr != null) {
                iv = sr.generateSeed(16);
            }
            keygen.init(128);
            SecretKey key = keygen.generateKey();
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, pk);
            fos.write(cipher.doFinal(key.getEncoded()));
            cipher.init(1, pk);
            fos.write(cipher.doFinal(iv));
            fos.write(new byte[32]);
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)key, new IvParameterSpec(iv));
            CipherOutputStream cos = new CipherOutputStream(new FilterOutputStream(fos){

                @Override
                public void close() throws IOException {
                }

                @Override
                public void flush() throws IOException {
                    this.out.flush();
                }

                @Override
                public void write(byte[] b) throws IOException {
                    this.out.write(b);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    this.out.write(b, off, len);
                }

                @Override
                public void write(int b) throws IOException {
                    this.out.write(b);
                }
            }, cipher);
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            int read = 0;
            byte[] buffer = new byte[Short.MAX_VALUE];
            while ((read = fis.read(buffer)) != -1) {
                if (read <= 0) continue;
                cos.write(buffer, 0, read);
                md.update(buffer, 0, read);
            }
            cos.close();
            fos.getChannel().position(512L);
            fos.write(md.digest());
            deleteDst = false;
        }
        finally {
            try {
                fis.close();
            }
            catch (Throwable throwable) {}
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
            if (deleteDst) {
                dstFile.delete();
            }
        }
    }

    public static PrivateKey getPrivateKey(String privateKey) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(Base64.decode(privateKey)));
    }

    public static PrivateKey getPrivateKey(byte[] bytes) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(bytes));
    }

    public static PublicKey getPublicKey(byte[] bytes) throws SignatureViolationException {
        try {
            return KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(bytes));
        }
        catch (InvalidKeySpecException e) {
            throw new SignatureViolationException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureViolationException(e);
        }
    }

    public static PublicKey getPublicKey(String base64Encoded) throws SignatureViolationException {
        try {
            return KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64.decode(base64Encoded)));
        }
        catch (InvalidKeySpecException e) {
            throw new SignatureViolationException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureViolationException(e);
        }
    }

    @Deprecated
    public static byte[] getSalt(boolean salt) throws NoSuchAlgorithmException {
        return AWSign.get16ByteSalt(salt);
    }

    public static byte[] getByteSalt(int length) throws NoSuchAlgorithmException {
        if (length <= 0) {
            return null;
        }
        byte[] saltBytes = new byte[length];
        if (sr != null) {
            sr.nextBytes(saltBytes);
        }
        return saltBytes;
    }

    public static byte[] get16ByteSalt(boolean salt) throws NoSuchAlgorithmException {
        if (!salt) {
            return null;
        }
        return AWSign.getByteSalt(16);
    }

    public static SecureRandom getSecureRandom() {
        return sr;
    }

    public static byte[] HMACSHA256(byte[] key, byte[] content) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(key, "HmacSHA256");
        sha256_HMAC.init(secret_key);
        return sha256_HMAC.doFinal(content);
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, IOException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
            AWSign.createKeyPair();
        }
    }

    public static void verify(byte[] dataToVerify, PublicKey pub, byte[] signature, boolean salted) throws SignatureViolationException {
        try {
            Signature sig = Signature.getInstance("Sha256WithRSA");
            sig.initVerify(pub);
            if (salted && signature != null && signature.length > 16) {
                byte[] salt = new byte[16];
                System.arraycopy(signature, 0, salt, 0, salt.length);
                byte[] actualSignature = new byte[signature.length - salt.length];
                System.arraycopy(signature, 16, actualSignature, 0, actualSignature.length);
                signature = actualSignature;
                sig.update(salt);
            }
            sig.update(dataToVerify);
            if (!sig.verify(signature)) {
                throw new SignatureViolationException("Signatur Check Failed");
            }
        }
        catch (SignatureViolationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SignatureViolationException(e);
        }
    }

    public static void verify(File f, PublicKey pub, byte[] signature, boolean salted, byte[] additionalBytes) throws SignatureViolationException {
        try {
            AWSign.verify(f.toURI().toURL().openStream(), pub, signature, salted, additionalBytes);
        }
        catch (SignatureViolationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SignatureViolationException(e);
        }
    }

    public static void verify(InputStream input, PublicKey pub, byte[] signature, boolean salted, byte[] additionalBytes) throws SignatureViolationException {
        try {
            int len;
            Signature sig = Signature.getInstance("Sha256WithRSA");
            sig.initVerify(pub);
            if (salted) {
                byte[] salt = new byte[signature.length - 256];
                System.arraycopy(signature, 0, salt, 0, salt.length);
                byte[] actualSignature = new byte[256];
                System.arraycopy(signature, signature.length - 256, actualSignature, 0, actualSignature.length);
                signature = actualSignature;
                sig.update(salt);
            }
            if (additionalBytes != null) {
                sig.update(additionalBytes);
            }
            byte[] buffer = new byte[Short.MAX_VALUE];
            while ((len = input.read(buffer)) != -1) {
                if (len <= 0) continue;
                sig.update(buffer, 0, len);
            }
            if (!sig.verify(signature)) {
                throw new SignatureViolationException("Signatur Check Failed");
            }
        }
        catch (SignatureViolationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SignatureViolationException(e);
        }
        finally {
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void checkIfPublicMatchesPrivateKey(PublicKey publicKey, PrivateKey privateKey) throws SignatureViolationException {
        try {
            byte[] test = (System.currentTimeMillis() + "").getBytes("UTF-8");
            AWSign.verify(test, publicKey, AWSign.createSign(test, privateKey, true), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new WTFException(e);
        }
    }

    static {
        try {
            sr = new SecureRandom();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

