/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.awfc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.appwork.utils.awfc.AWFCEntry;
import org.appwork.utils.awfc.AWFCEntryOptions;
import org.appwork.utils.awfc.AWFCUtils;
import org.appwork.utils.net.LimitedInputStream;

public class AWFCInputStream
extends InputStream {
    private final InputStream is;
    private LimitedInputStream lis = null;
    private MessageDigest md = null;
    private boolean headerRead = false;
    private AWFCEntryOptions currentEntry = null;
    private final byte[] skipBuffer = new byte[Short.MAX_VALUE];
    private AWFCUtils utils;
    private int version = -1;

    public AWFCInputStream(InputStream is) {
        this.is = is;
        this.utils = new AWFCUtils(){

            @Override
            public InputStream getCurrentInputStream() throws IOException {
                return AWFCInputStream.this.getCurrentInputStream();
            }
        };
    }

    @Override
    public int available() throws IOException {
        return this.getCurrentInputStream().available();
    }

    @Override
    public void close() throws IOException {
        this.getCurrentInputStream().close();
    }

    protected InputStream getInputStream() throws IOException {
        return this.is;
    }

    private synchronized InputStream getCurrentInputStream() throws IOException {
        if (this.lis != null) {
            return this.lis;
        }
        return this.is;
    }

    private void verifyHash(AWFCEntryOptions entryOptions, byte[] streamHash) throws IOException {
        AWFCEntry entry = entryOptions.getEntry();
        byte[] storedEntryHash = entry.getHash();
        if (!Arrays.equals(streamHash, storedEntryHash)) {
            if (storedEntryHash == null && entry.getSize() == 0L && this.getVersion() == 1) {
                return;
            }
            throw new IOException("Wrong hash for Entry: " + entry);
        }
    }

    protected LimitedInputStream getLimitedInputStream(AWFCEntryOptions entry) throws IOException {
        if (entry != null) {
            MessageDigest md;
            if (this.md != null) {
                this.md.reset();
                md = this.md;
            } else {
                md = null;
            }
            long inputLimit = entry.getEntry().getSize();
            final boolean hasPayLoad = entry.hasPayLoad();
            return new LimitedInputStream(this.is, hasPayLoad ? inputLimit : 0L){
                private byte[] hash;
                {
                    super(in, limit);
                    this.hash = null;
                }

                @Override
                public int available() throws IOException {
                    long ret = this.getLimit() - this.transferedBytes();
                    if (ret > Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    return (int)ret;
                }

                @Override
                public int read() throws IOException {
                    int ret = super.read();
                    if (hasPayLoad && md != null) {
                        if (ret != -1) {
                            md.update((byte)ret);
                        } else if (ret == -1) {
                            if (this.hash == null) {
                                this.hash = md.digest();
                            }
                            AWFCInputStream.this.verifyHash(AWFCInputStream.this.currentEntry, this.hash);
                        }
                    }
                    return ret;
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    int ret = super.read(b, off, len);
                    if (hasPayLoad && md != null) {
                        if (ret > 0) {
                            md.update(b, off, ret);
                        } else if (ret == -1) {
                            if (this.hash == null) {
                                this.hash = md.digest();
                            }
                            AWFCInputStream.this.verifyHash(AWFCInputStream.this.currentEntry, this.hash);
                        }
                    }
                    return ret;
                }

                @Override
                public long skip(long n) throws IOException {
                    if (n < (long)AWFCInputStream.this.skipBuffer.length) {
                        return this.read(AWFCInputStream.this.skipBuffer, 0, (int)n);
                    }
                    return this.read(AWFCInputStream.this.skipBuffer, 0, this.skipBuffer.length);
                }
            };
        }
        return null;
    }

    protected synchronized void skipEntry(AWFCEntryOptions entry) throws IOException {
        while (this.lis.available() > 0) {
            this.lis.skip(this.lis.available());
        }
    }

    public synchronized AWFCEntry getNextEntry() throws IOException {
        this.readAWFCHeader();
        if (this.currentEntry != null) {
            try {
                this.skipEntry(this.currentEntry);
            }
            finally {
                this.lis = null;
                this.currentEntry = null;
            }
        }
        this.currentEntry = this.readAWFCEntry();
        if (this.currentEntry == null) {
            return null;
        }
        this.lis = this.getLimitedInputStream(this.currentEntry);
        return this.currentEntry.getEntry();
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        return this.getCurrentInputStream().read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.getCurrentInputStream().read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.getCurrentInputStream().read(b, off, len);
    }

    private AWFCEntryOptions readAWFCEntry() throws IOException {
        AWFCEntry entry;
        boolean hasPayLoad;
        int stringSize = 0;
        try {
            stringSize = this.utils.readShort();
        }
        catch (EOFException e) {
            return null;
        }
        String path = this.utils.readString(stringSize);
        int entryOptions = this.utils.ensureRead();
        boolean isFolder = (entryOptions & 1) == 0;
        boolean bl = hasPayLoad = (entryOptions & 2) == 0;
        if (isFolder) {
            entry = new AWFCEntry(path + "/", 0L, null);
        } else {
            long size = this.utils.readLongOptimized();
            byte[] hash = this.md != null && (size > 0L || this.getVersion() >= 2) ? this.utils.ensureRead(this.md.getDigestLength(), null) : null;
            entry = new AWFCEntry(path, size, hash);
        }
        return new AWFCEntryOptions(entry, !hasPayLoad);
    }

    public int getVersion() {
        return this.version;
    }

    public synchronized boolean readAWFCHeader() throws IOException {
        if (!this.headerRead) {
            this.version = this.utils.ensureRead();
            switch (this.version) {
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    throw new IOException("Unknown AWFC Version " + this.version);
                }
            }
            if (this.utils.readBoolean()) {
                int stringSize = this.utils.readShort();
                String mdAlgo = this.utils.readString(stringSize);
                try {
                    this.md = MessageDigest.getInstance(mdAlgo);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException(e);
                }
                if (this.md.getDigestLength() != this.utils.readShort()) {
                    throw new IOException("Hashlength does not match for given md: " + mdAlgo);
                }
            }
            this.headerRead = true;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
    }

    @Override
    public long skip(long n) throws IOException {
        return this.getCurrentInputStream().skip(n);
    }
}

