/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.appwork.exceptions.WTFException;

public class ZipContentHasher {
    public static final Comparator<? super String> SORTER = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            int n1 = s1.length();
            int n2 = s2.length();
            int min = Math.min(n1, n2);
            for (int i = 0; i < min; ++i) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 == (c2 = s2.charAt(i))) continue;
                return c1 - c2;
            }
            return n1 - n2;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContentSHA256(File file, Customizer custom) throws IOException {
        if (!file.isFile()) {
            throw new WTFException("ContentSHA256 of directory!?:" + file);
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            byte[] byArray = ZipContentHasher.getContentSHA256("", fis, custom);
            return byArray;
        }
        finally {
            fis.close();
        }
    }

    public static byte[] getContentSHA256(String path, InputStream is, Customizer custom) throws IOException {
        HashMap<String, byte[]> hashes = ZipContentHasher.getHashes(path, is, custom, true);
        ArrayList<String> list = new ArrayList<String>(hashes.keySet());
        Collections.sort(list, SORTER);
        try {
            Charset utf = Charset.forName("UTF-8");
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            for (String key : list) {
                md.update(key.getBytes(utf));
                byte[] hash = hashes.get(key);
                if (hash == null) continue;
                md.update(hash);
            }
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    public static HashMap<String, byte[]> getHashes(String path, InputStream is, Customizer custom, boolean throwIOException) throws IOException {
        is = new FilterInputStream(is){

            @Override
            public void close() throws IOException {
            }
        };
        ZipInputStream zipStream = new ZipInputStream(is);
        is = null;
        try {
            HashMap<String, byte[]> results;
            block14: {
                results = new HashMap<String, byte[]>();
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                byte[] buffer = new byte[Short.MAX_VALUE];
                if (path.length() > 0) {
                    path = path + "!";
                }
                try {
                    ZipEntry e;
                    while ((e = zipStream.getNextEntry()) != null) {
                        if (custom != null && custom.handle(path, zipStream, e, results)) continue;
                        if (e.isDirectory()) {
                            results.put(path + e.getName(), null);
                        } else if (e.getName().toLowerCase(Locale.ROOT).endsWith(".jar") || e.getName().toLowerCase(Locale.ROOT).endsWith(".zip")) {
                            results.putAll(ZipContentHasher.getHashes(path + e.getName(), zipStream, custom, throwIOException));
                        } else {
                            int len;
                            md.reset();
                            while ((len = zipStream.read(buffer)) != -1) {
                                if (len <= 0) continue;
                                md.update(buffer, 0, len);
                            }
                            results.put(path + e.getName(), md.digest());
                        }
                        zipStream.closeEntry();
                    }
                }
                catch (IOException e) {
                    if (!throwIOException) break block14;
                    throw e;
                }
            }
            HashMap<String, byte[]> hashMap = results;
            return hashMap;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        finally {
            zipStream.close();
        }
    }

    public static interface Customizer {
        public boolean handle(String var1, ZipInputStream var2, ZipEntry var3, HashMap<String, byte[]> var4) throws IOException;
    }
}

