/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class ProcMounts {
    private final String device;
    private final String fileSystem;
    private final boolean readOnly;
    private final String mountPoint;

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String getFileSystem() {
        return this.fileSystem;
    }

    public String getDevice() {
        return this.device;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    private ProcMounts(String device, String mountPoint, String fileSystem, boolean readOnly) {
        this.device = device;
        this.mountPoint = mountPoint;
        this.fileSystem = fileSystem;
        this.readOnly = readOnly;
    }

    public String toString() {
        return "Device:" + this.getDevice() + "|MountPoint:" + this.getMountPoint() + "|FileSystem:" + this.getFileSystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ProcMounts> list() throws IOException {
        FileInputStream fis = null;
        try {
            File procMounts = new File("/proc/mounts");
            ArrayList<ProcMounts> ret = new ArrayList<ProcMounts>();
            if (procMounts.exists()) {
                fis = new FileInputStream(procMounts);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    String[] infos = line.split(" ");
                    if (infos.length < 6) continue;
                    boolean readOnly = ProcMounts.isReadOnly(infos[3]);
                    ProcMounts mount = new ProcMounts(infos[0], infos[1].replaceAll("\\\\040", " "), infos[2], readOnly);
                    ret.add(mount);
                }
                fis.close();
                fis = null;
            }
            ArrayList<ProcMounts> arrayList = ret;
            return arrayList;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    private static boolean isReadOnly(String options) {
        for (String option : options.split(",")) {
            if (!"ro".equalsIgnoreCase(option)) continue;
            return true;
        }
        return false;
    }
}

