/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LEB128 {
    public static long read(long maxShift, InputStream is, boolean alwaysThrowEOF) throws IOException {
        long ret = 0L;
        int shift = 0;
        do {
            int read;
            if ((read = is.read()) == -1) {
                if (shift > 0 && alwaysThrowEOF) {
                    throw new EOFException();
                }
                return -1L;
            }
            long value = read & 0x7F;
            int msb = (read & 0xFF) >> 7;
            ret |= value << shift;
            if (msb != 0) continue;
            return ret;
        } while ((long)(shift += 7) <= maxShift);
        throw new ArithmeticException("number shift overflow:" + shift);
    }

    public static long readLong(InputStream is, boolean alwaysThrowEOF) throws IOException {
        return LEB128.read(56L, is, alwaysThrowEOF);
    }

    public static int readInt(InputStream is, boolean alwaysThrowEOF) throws IOException {
        long ret = LEB128.read(28L, is, alwaysThrowEOF);
        if (ret > Integer.MAX_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)ret;
    }

    public static short readShort(InputStream is, boolean alwaysThrowEOF) throws IOException {
        long ret = LEB128.read(14L, is, alwaysThrowEOF);
        if (ret > 32767L) {
            throw new ArithmeticException("short overflow");
        }
        return (short)ret;
    }

    public static byte readByte(InputStream is, boolean alwaysThrowEOF) throws IOException {
        long ret = LEB128.read(7L, is, alwaysThrowEOF);
        if (ret > 127L) {
            throw new ArithmeticException("byte overflow");
        }
        return (byte)ret;
    }

    public static void write(OutputStream out, long value) throws IOException {
        if (value < 0L) {
            throw new IllegalArgumentException("value must be >= 0");
        }
        for (long remaining = value >>> 7; remaining != 0L; remaining >>>= 7) {
            out.write((byte)(value & 0x7FL | 0x80L));
            value = remaining;
        }
        out.write((byte)(value & 0x7FL));
    }
}

