/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class InMemoryJarClassLoader
extends URLClassLoader {
    protected final byte[] jarFileBytes;
    protected final HashSet<String> entries = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InMemoryJarClassLoader(byte[] jarFileBytes) throws IOException {
        super(new URL[0], InMemoryJarClassLoader.class.getClassLoader());
        this.jarFileBytes = jarFileBytes;
        JarInputStream is = new JarInputStream(new ByteArrayInputStream(this.jarFileBytes));
        try {
            JarEntry entry = null;
            while ((entry = is.getNextJarEntry()) != null) {
                this.entries.add(entry.getName());
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getInputStream(String entryName) throws IOException {
        if (this.entries.contains(entryName)) {
            JarInputStream is = new JarInputStream(new ByteArrayInputStream(this.jarFileBytes));
            boolean closeFlag = true;
            try {
                JarEntry entry = null;
                while ((entry = is.getNextJarEntry()) != null) {
                    if (!entry.getName().equals(entryName)) continue;
                    closeFlag = false;
                    JarInputStream jarInputStream = is;
                    return jarInputStream;
                }
                InputStream inputStream = null;
                return inputStream;
            }
            finally {
                if (closeFlag) {
                    is.close();
                }
            }
        }
        return null;
    }

    protected String getClassRessourceName(String className) {
        return className.replace(".", "/") + ".class";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Class<?> findClass(String className) throws ClassNotFoundException {
        Class<?> clazz;
        Class<?> clazz2 = this.findLoadedClass(className);
        if (clazz2 != null) {
            return clazz2;
        }
        String jarClassName = this.getClassRessourceName(className);
        if (!this.entries.contains(jarClassName)) {
            return super.findClass(className);
        }
        InputStream is = this.getInputStream(jarClassName);
        if (is == null) throw new ClassNotFoundException("could not find:" + className);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[Short.MAX_VALUE];
            int read = 0;
            while ((read = is.read(buffer)) != -1) {
                if (read <= 0) continue;
                bos.write(buffer, 0, read);
            }
            byte[] classByte = bos.toByteArray();
            this.definePackage(className);
            clazz = this.defineClass(className, classByte, 0, classByte.length, (ProtectionDomain)null);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ClassNotFoundException("could not find:" + className, e);
            }
        }
        try {
            is.close();
            return clazz;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return clazz;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (this.entries.contains(name)) {
            try {
                return this.getInputStream(name);
            }
            catch (IOException e) {
                return null;
            }
        }
        return super.getResourceAsStream(name);
    }

    private void definePackage(String className) {
        String pkgname;
        int i = className.lastIndexOf(46);
        if (i != -1 && this.getPackage(pkgname = className.substring(0, i)) == null) {
            this.definePackage(pkgname, null, null, null, null, null, null, null);
        }
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        if (!this.entries.contains(name)) {
            return super.findResources(name);
        }
        URL url = this.findResource(name);
        final AtomicReference<URL> elem = new AtomicReference<URL>(url);
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return elem.get() != null;
            }

            @Override
            public URL nextElement() {
                return elem.getAndSet(null);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public URL findResource(final String name) {
        if (!this.entries.contains(name)) {
            return super.findResource(name);
        }
        try {
            JarInputStream is = new JarInputStream(new ByteArrayInputStream(this.jarFileBytes));
            try {
                JarEntry entry = null;
                while ((entry = is.getNextJarEntry()) != null) {
                    if (!entry.getName().equals(name)) continue;
                    URL uRL = new URL(null, "jarInMemory:/" + name, new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(URL u) throws IOException {
                            return new URLConnection(u){

                                @Override
                                public void connect() throws IOException {
                                }

                                @Override
                                public InputStream getInputStream() throws IOException {
                                    return InMemoryJarClassLoader.this.getInputStream(name);
                                }
                            };
                        }
                    });
                    return uRL;
                }
                URL uRL = null;
                return uRL;
            }
            finally {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        String jarClassName = this.getClassRessourceName(className);
        if (!this.entries.contains(jarClassName)) {
            return super.loadClass(className, resolve);
        }
        Object lock = this;
        try {
            lock = this.getClassLoadingLock(className);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        InMemoryJarClassLoader inMemoryJarClassLoader = lock;
        synchronized (inMemoryJarClassLoader) {
            Class<?> clazz = this.findLoadedClass(className);
            if (clazz == null) {
                clazz = this.findClass(className);
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }
}

