/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.net.URL;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.Application;
import org.appwork.utils.Time;
import org.appwork.utils.logging2.LogInterface;

public class DebugMode {
    public static boolean TRUE_IN_IDE_ELSE_FALSE = !DebugMode.isJared();

    public static final <T> T TRIGGER_BUILD_ERROR(T ... forward) {
        DebugMode.logInIDEOnly(new Exception("REMOVE THIS CODE BEFORE BUILD!"));
        if (forward == null || forward.length == 0) {
            return null;
        }
        return forward[0];
    }

    private static final boolean isJared() {
        String name = Application.class.getName().replaceAll("\\.", "/") + ".class";
        ClassLoader cll = Application.class.getClassLoader();
        if (cll == null) {
            return true;
        }
        URL caller = cll.getResource(name);
        if (caller == null) {
            return false;
        }
        boolean ret = caller.toString().matches("jar\\:.*\\.(jar|exe)\\!.*");
        return ret;
    }

    public static <T extends Throwable> T logInIDEOnly(LogInterface logger, T e) {
        if (TRUE_IN_IDE_ELSE_FALSE && logger != null) {
            logger.log(e);
        }
        return e;
    }

    public static <T extends Throwable> boolean throwInIDEElse(T e) throws T {
        if (TRUE_IN_IDE_ELSE_FALSE && e != null) {
            throw e;
        }
        return true;
    }

    public static <T extends Throwable> T logInIDEOnly(T e) {
        return DebugMode.logInIDEOnly(LogV3.defaultLogger(), e);
    }

    public static void logInfoInIDEOnly(String e) {
        if (TRUE_IN_IDE_ELSE_FALSE && e != null) {
            LogV3.info(e);
        }
    }

    public static void debugger(boolean breakIf, Object ... context) {
        if (!TRUE_IN_IDE_ELSE_FALSE || !breakIf) {
            return;
        }
        long t = Time.systemIndependentCurrentJVMTimeMillis();
        LogV3.severe("BREAKPOINT");
        if (Time.systemIndependentCurrentJVMTimeMillis() - t < 20L) {
            throw new WTFException("A Breakpoint 2 lines before was expected. Please set a breakpoint");
        }
    }

    public static void debugger(String reason) {
        DebugMode.debugger(true, reason);
    }

    public static void debugger() {
        DebugMode.debugger(true, new Object[0]);
    }

    public static void debugger(Exception e) {
        DebugMode.debugger(e != null, e);
    }

    public static void breakIf(boolean breakIf, Object ... context) {
        DebugMode.debugger(breakIf, context);
    }

    public static void breakIfNot(boolean breakIfNot, Object ... context) {
        DebugMode.breakIf(!breakIfNot, context);
    }
}

