/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.awt.Color;

public class ColorUtils {
    public static Color getAlphaInstance(Color background, int alpha) {
        Color ret = new Color(background.getRGB() & 0xFFFFFF | (alpha & 0xFF) << 24, true);
        return ret;
    }

    public static Color mixColors(Color bg, Color fg, int weighta, int weightb) {
        int ba = weightb;
        int aa = weighta;
        int r = (bg.getRed() * aa + fg.getRed() * ba) / (aa + ba);
        int g = (bg.getGreen() * aa + fg.getGreen() * ba) / (aa + ba);
        int b = (bg.getBlue() * aa + fg.getBlue() * ba) / (aa + ba);
        double transbg = (double)(255 - bg.getAlpha()) / 255.0;
        double transfg = (double)(255 - fg.getAlpha()) / 255.0;
        int a = (int)(255.0 * (transbg * transfg));
        return new Color(r, g, b, 255 - a);
    }

    public static Color getContrastBWColor(Color color) {
        if (color == null) {
            return null;
        }
        int luminance = (299 * color.getRed() + 587 * color.getGreen() + 114 * color.getBlue()) / 1000;
        return luminance < 128 ? Color.white : Color.black;
    }
}

