/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange.track;

import org.appwork.storage.Storable;
import org.appwork.storage.TypeRef;
import org.appwork.updatesys.transport.exchange.AbstractTrackDataItem;
import org.appwork.updatesys.transport.exchange.SyncedTime;
import org.appwork.updatesys.transport.exchange.batch.BatchJobType;

public class TrafficLog
extends AbstractTrackDataItem
implements Storable {
    public static final TypeRef<TrafficLog> TYPEREF = new TypeRef<TrafficLog>(TrafficLog.class){};
    protected volatile long bytesLoaded = -1L;
    protected volatile long bytesTotal = -1L;
    protected volatile String cdnSignature = CDNSIGNATURE.UNKNOWN.name();
    protected volatile SyncedTime connectDate = null;
    protected volatile SyncedTime startDate = null;
    protected volatile SyncedTime stopDate = null;
    protected volatile SyncedTime connectedDate = null;
    protected volatile String contentType = null;
    protected volatile long downloadID = -1L;
    protected volatile long duration = -1L;
    protected volatile boolean finalized = false;
    protected volatile String host = null;
    protected volatile int logVersion = 1;
    protected volatile long responseBytes = -1L;
    protected volatile int responseCode = -1;
    protected volatile boolean resume = false;
    protected volatile long resumeFrom = -1L;
    protected volatile String serverTag = null;
    protected volatile String status = null;
    protected volatile String url = null;

    public SyncedTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(SyncedTime startDate) {
        this.startDate = startDate;
    }

    public SyncedTime getStopDate() {
        return this.stopDate;
    }

    public void setStopDate(SyncedTime stopDate) {
        this.stopDate = stopDate;
    }

    public TrafficLog() {
        super(BatchJobType.TRAFFIC);
    }

    public TrafficLog(String url, long downloadID) {
        this();
        this.setUrl(url);
        this.downloadID = downloadID;
    }

    public long getBytesLoaded() {
        return this.bytesLoaded;
    }

    public long getBytesTotal() {
        return this.bytesTotal;
    }

    public String getCdnSignature() {
        return this.cdnSignature;
    }

    public SyncedTime getConnectDate() {
        return this.connectDate;
    }

    public SyncedTime getConnectedDate() {
        return this.connectedDate;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getDownloadID() {
        return this.downloadID;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getHost() {
        return this.host;
    }

    public int getLogVersion() {
        return this.logVersion;
    }

    public long getResponseBytes() {
        return this.responseBytes;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public long getResumeFrom() {
        return this.resumeFrom;
    }

    public String getServerTag() {
        return this.serverTag;
    }

    public String getStatus() {
        return this.status;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public boolean isResume() {
        return this.resume || this.getResumeFrom() > 0L;
    }

    public void setBytesLoaded(long bytes) {
        this.bytesLoaded = bytes;
    }

    public void setBytesTotal(long expectedBytes) {
        this.bytesTotal = expectedBytes;
    }

    public void setCdnSignature(String cdnSignature) {
        this.cdnSignature = cdnSignature;
    }

    public void setConnectDate(SyncedTime connectDate) {
        this.connectDate = connectDate;
    }

    public void setConnectedDate(SyncedTime connectedDate) {
        this.connectedDate = connectedDate;
    }

    @Override
    public void setDate(SyncedTime timeStamp) {
        super.setDate(timeStamp);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setDownloadID(long downloadID) {
        this.downloadID = downloadID;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setFinalized(boolean finalized) {
        this.finalized = finalized;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setLogVersion(int logVersion) {
        this.logVersion = logVersion;
    }

    public void setResponseBytes(long responseBytes) {
        this.responseBytes = responseBytes;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public void setResume(boolean resume) {
        this.resume = resume;
    }

    public void setResumeFrom(long resumeFrom) {
        this.resumeFrom = resumeFrom;
    }

    public void setServerTag(String serverTag) {
        this.serverTag = serverTag;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public TrafficLog status(String status) {
        this.status = status;
        return this;
    }

    public String toString() {
        return "TimeStamp:" + this.getDate() + "|Status:" + this.getStatus() + "|Url:" + this.getUrl() + "|Bytes:" + this.getBytesLoaded() + "|ResumeFrom:" + this.getResumeFrom() + "|ExpectedBytes:" + this.getBytesTotal() + "|ResponseBytes:" + this.getResponseBytes() + "|Duration:" + this.getDuration() + "|Resume:" + this.isResume();
    }

    public static enum STATUS {
        CONNECTED,
        CONNECTING,
        DOWNLOADING,
        HASH,
        INCOMPLETE,
        INTERRUPTED,
        MISSMATCH,
        OK,
        UNKNOWN;

    }

    public static enum CDNSIGNATURE {
        FILTERED,
        INVALID,
        MISSING,
        OUTDATED,
        UNKNOWN,
        VALID;

    }
}

