/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange.track;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.appwork.storage.SimpleTypeRef;
import org.appwork.storage.Storable;
import org.appwork.updatesys.transport.exchange.track.Category;
import org.appwork.updatesys.transport.exchange.track.Entity;
import org.appwork.updatesys.transport.exchange.track.HIDFeature;
import org.appwork.updatesys.transport.exchange.track.MayChangeOn;
import org.appwork.updatesys.transport.exchange.track.Property;
import org.appwork.updatesys.transport.exchange.track.WMIProperty;
import org.appwork.utils.Hash;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.HexFormatter;

public class HardwareInfoStorable
implements Storable {
    public static final SimpleTypeRef<HardwareInfoStorable> TYPE = new SimpleTypeRef((Type)((Object)HardwareInfoStorable.class));
    private static final String VERSION = "9";
    private static final Pattern PATTERN_VENDOR = Pattern.compile("(?:^|&|\\\\)(VEN_[^&]+)", 66);
    private static final Pattern PATTERN_SOCKET = Pattern.compile("([^\\\\]+)", 66);
    private static final Pattern PATTERN_DEV = Pattern.compile("(?:^|&|\\\\)(DEV_[^&]+)", 66);
    private static final Pattern PATTERN_SUBSYS = Pattern.compile("(?:^|&|\\\\)(SUBSYS_[^&]+)", 66);
    private static final Pattern PATTERN_REV = Pattern.compile("(?:^|&|\\\\)(REV_[^&]+)", 66);
    private static final Pattern PATTERN_PROD = Pattern.compile("(?:^|&|\\\\)(PROD_[^&]+)", 66);
    private String staticHID;
    private String dynamicHID;
    private long time;
    private static final int FEATURES_FLAG_BYTES = 3;
    public static final String TPM = "TrustedPlatformModule";
    private HashMap<String, Category> categories;
    public static final String INFO = "Info";
    public static final String OPERATING_SYSTEM_NAME = "OperatingSystemName";
    public static final String OPERATING_SYSTEM_VERSION = "OperatingSystemVersion";
    public static final String SYSTEM_MODEL = "SystemModel";
    public static final String BIOS_VERSION = "BiosVersion";
    public static final String SYSTEM_MANUFACTURER = "SystemManufacturer";
    public static final String PNP_DEVICE_ID = "PNPDeviceID";
    public static final String DEVICE_ID = "DeviceID";
    public static final String CRYPTOGRAPHY_MACHINE_GUID = "Cryptography.MachineGuid";
    public static final String WINDOWS = "Windows";
    public static final String SQM_CLIENT_MACHINE_ID = "SQMClient.MachineId";
    public static final String TPM_FIRMWARE = "TpmFirmware";
    public static final String TPM_LEVEL = "TpmLevel";
    public static final String TPM_REVISION = "TpmRevision";
    public static final String TPM_VENDOR = "TpmVendor";
    public static final String TPM_VERSION = "TpmVersion";
    public static final String PCP_PLATFORM = "PcpPlatform";
    public static final String PCP_PROVIDER_VERSION = "PcpProviderVersion";
    public static final String TPM_PCR_0 = "TpmPcr0";
    public static final String TPM_DEVICE_ID = "TpmDeviceID";
    public static final String LINUX = "Linux";

    public String getStaticHID() {
        return this.staticHID;
    }

    public void setStaticHID(String staticHID) {
        this.staticHID = staticHID;
    }

    public String getDynamicHID() {
        return this.dynamicHID;
    }

    public void setDynamicHID(String dynamicHID) {
        this.dynamicHID = dynamicHID;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public String toIDString(boolean addOptions, MayChangeOn ... changeOns) {
        int maxPropLength = 0;
        int maxValueLength = 0;
        for (Category c : this.categories.values()) {
            for (Entity e : c.getEntities()) {
                for (Property prop : e.getProperties()) {
                    maxPropLength = Math.max(maxPropLength, prop.getKey().length());
                    maxValueLength = Math.max(maxValueLength, prop.getValue().length());
                }
            }
        }
        ArrayList<String> keys = new ArrayList<String>(this.categories.keySet());
        Collections.sort(keys);
        StringBuilder sb = new StringBuilder();
        sb.append("HID Version 9\r\n");
        for (String key : keys) {
            Category cat = this.categories.get(key);
            cat.sort();
            if (sb.length() > 0) {
                sb.append("\r\n");
            }
            sb.append(StringUtils.fillPost(cat.getName(), "=", 90));
            int i = 1;
            for (Entity es : cat.getEntities()) {
                boolean addedEntityHeader = false;
                for (Property p : es.getProperties()) {
                    if (p.getOptions() != null) {
                        HashSet<MayChangeOn> req = new HashSet<MayChangeOn>(Arrays.asList(p.getOptions()));
                        for (MayChangeOn mco : changeOns) {
                            req.remove((Object)mco);
                        }
                        if (req.size() > 0) continue;
                    }
                    if (!addedEntityHeader) {
                        sb.append("\r\n");
                        sb.append(StringUtils.fillPost("   Entity " + i++, "-", 90));
                        addedEntityHeader = true;
                    }
                    if (sb.length() > 0) {
                        sb.append("\r\n");
                    }
                    sb.append(StringUtils.fillPost("      " + p.getKey(), " ", maxPropLength + 3 + 6));
                    sb.append(" = ");
                    if (PNP_DEVICE_ID.equals(p.getKey())) {
                        if (!p.getValue().trim().isEmpty()) {
                            String ven = this.regMatch(PATTERN_VENDOR, p.getValue());
                            String socket = this.regMatch(PATTERN_SOCKET, p.getValue());
                            String dev = this.regMatch(PATTERN_DEV, p.getValue());
                            String prod = this.regMatch(PATTERN_PROD, p.getValue());
                            String subsys = this.regMatch(PATTERN_SUBSYS, p.getValue());
                            String rev = this.regMatch(PATTERN_REV, p.getValue());
                            sb.append(socket + "&" + ven + "&" + dev + "&" + subsys + "&" + rev + "&" + prod);
                        }
                    } else {
                        sb.append(p.getValue());
                    }
                    if (!addOptions) continue;
                    sb.append(" " + Arrays.toString((Object[])p.getOptions()));
                }
            }
        }
        return sb.toString();
    }

    private String regMatch(Pattern p, String value) {
        Matcher matcher = p.matcher(value);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public String toString() {
        return this.toIDString(true, MayChangeOn.values());
    }

    public String toHid(WMIProperty[] importants, MayChangeOn ... additionalValues) {
        String str = this.toIDString(false, additionalValues);
        BigInteger includedExtras = new BigInteger("0", 10);
        for (MayChangeOn c : additionalValues) {
            includedExtras = includedExtras.setBit(c.feature.bit);
        }
        for (Category c : this.categories.values()) {
            for (Entity e : c.getEntities()) {
                for (Property prop : e.getProperties()) {
                    if (prop.getOptions() != null) {
                        HashSet<MayChangeOn> req = new HashSet<MayChangeOn>(Arrays.asList(prop.getOptions()));
                        MayChangeOn[] mayChangeOnArray = additionalValues;
                        int n = mayChangeOnArray.length;
                        for (int i = 0; i < n; ++i) {
                            MayChangeOn mco = mayChangeOnArray[i];
                            req.remove((Object)mco);
                        }
                        if (req.size() > 0) continue;
                    }
                    for (WMIProperty p : importants) {
                        HIDFeature feature = p.getFeaturesBitToSet(c, e, prop);
                        if (feature == null) continue;
                        includedExtras = includedExtras.setBit(feature.bit);
                    }
                    if (WINDOWS.equals(c.getName())) {
                        if (SQM_CLIENT_MACHINE_ID.equals(prop.getKey())) {
                            includedExtras = includedExtras.setBit(HIDFeature.WINDOWS_SQM_ID.bit);
                        } else if (CRYPTOGRAPHY_MACHINE_GUID.equals(prop.getKey())) {
                            includedExtras = includedExtras.setBit(HIDFeature.WINDOWS_CRYPTO_GUID.bit);
                        }
                    }
                    if (!TPM.equals(c.getName()) || !TPM_PCR_0.equals(prop.getKey())) continue;
                    includedExtras = includedExtras.setBit(HIDFeature.TPM_PCR0.bit);
                }
            }
        }
        byte[] ba = includedExtras.toByteArray();
        String featuresFlag = HexFormatter.byteArrayToHex(ba);
        featuresFlag = StringUtils.fillPre(featuresFlag, "0", 6);
        includedExtras.setBit(HIDFeature.VERSION_1.bit);
        return featuresFlag + Hash.getSHA256(str);
    }

    public Category _getCategory(String categoryName) {
        Category ret;
        if (this.categories == null) {
            this.categories = new HashMap();
        }
        if ((ret = this.categories.get(categoryName)) == null) {
            ret = new Category(categoryName);
            this.categories.put(categoryName, ret);
        }
        return ret;
    }

    public HashMap<String, Category> getCategories() {
        if (this.categories == null) {
            this.categories = new HashMap();
        }
        return this.categories;
    }

    public void setCategories(HashMap<String, Category> categories) {
        this.categories = categories;
    }

    public ArrayList<String> _getChangedKeys(HardwareInfoStorable o, MayChangeOn ... changeOns) {
        ArrayList<String> ret = new ArrayList<String>();
        HashMap<String, HashSet<String>> a = this.toCompare(changeOns);
        HashMap<String, HashSet<String>> b = o.toCompare(changeOns);
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(a.keySet());
        keys.addAll(b.keySet());
        for (String key : keys) {
            HashSet<String> va = a.get(key);
            HashSet<String> vb = b.get(key);
            if (va == null) {
                va = new HashSet();
            }
            if (vb == null) {
                vb = new HashSet();
            }
            if (va.equals(vb)) continue;
            ret.add(key);
        }
        return ret;
    }

    private HashMap<String, HashSet<String>> toCompare(MayChangeOn[] changeOns) {
        HashMap<String, HashSet<String>> ret = new HashMap<String, HashSet<String>>();
        for (Category c : this.getCategories().values()) {
            for (Entity e : c.getEntities()) {
                for (Property p : e.getProperties()) {
                    if (p.getOptions() != null) {
                        HashSet<MayChangeOn> req = new HashSet<MayChangeOn>(Arrays.asList(p.getOptions()));
                        for (MayChangeOn mco : changeOns) {
                            req.remove((Object)mco);
                        }
                        if (req.size() > 0) continue;
                    }
                    String key = c.getName() + "." + p.getKey();
                    HashSet<String> list = ret.get(key);
                    list = new HashSet();
                    ret.put(key, list);
                    list.add(p.getValue());
                }
            }
        }
        return ret;
    }

    public static String getVersion(String hid) {
        if (hid.length() == 70) {
            return "0";
        }
        if (hid.length() >= 72) {
            int length = Integer.parseInt(hid.substring(0, 1), 16);
            return hid.substring(1, 1 + length);
        }
        return null;
    }

    public static ArrayList<HIDFeature> getFeatures(String hid) {
        BigInteger features;
        ArrayList<HIDFeature> ret = new ArrayList<HIDFeature>();
        if (hid.length() > 71) {
            int length = Integer.parseInt(hid.substring(0, 1), 16);
            features = new BigInteger(hid.substring(1, 1 + length), 16);
        } else {
            features = new BigInteger(hid.substring(0, 6), 16);
        }
        for (HIDFeature f : HIDFeature.values()) {
            if (!features.testBit(f.bit)) continue;
            ret.add(f);
        }
        return ret;
    }

    public static boolean isValidHID(String newID) {
        if (newID == null) {
            return false;
        }
        return newID.matches("^[0-9a-fA-F]{70}$");
    }

    static {
        HashSet<Object> dupe = new HashSet<Object>();
        for (Field f : HardwareInfoStorable.class.getFields()) {
            if (!f.getName().startsWith("CONTAINS_")) continue;
            try {
                if (!dupe.add(f.get(null))) {
                    throw new RuntimeException("BIT Set FLAG DUPE");
                }
                if (((Number)f.get(null)).intValue() < 24) continue;
                throw new RuntimeException("BIT Is higher than 24");
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }
}

