/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange.setup;

import org.appwork.storage.Storable;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.StorableExample;
import org.appwork.storage.StorableLink;
import org.appwork.storage.StorableSee;
import org.appwork.updatesys.transport.exchange.setup.GenericConditionMatcher;
import org.appwork.updatesys.transport.exchange.setup.PreCondition;

public class UninstallRule
implements Storable {
    @StorableDoc(value="Execute only if the conditions resolve to true. The conditions are matched against an instance of ExecuteConditionMatcher. Alternativly, a match against a filepath is possible: {\"\u00a7file\":{\"\u00a7options\":{\"path\":\".%CONNECT\"},\"directory\":true}}")
    @StorableLink(labels={"Matches against ExecuteConditionMatcher", "Supports FileLink"}, hrefs={"https://projects.appwork.org/projects/connect-system-documentation/wiki/ExecuteConditionMatcher", "https://projects.appwork.org/projects/connect-system-documentation/wiki/FileLink"})
    @StorableSee(value={GenericConditionMatcher.class})
    private PreCondition[] conditions;
    private String dir;
    private String[] include = new String[]{".*"};
    private String[] exclude;

    @StorableDoc(value="A relative path (Dynamic Links can be used) to the base directory of the rule.")
    @StorableExample(value="\".%INSTALL_ROOT\"")
    public String getDir() {
        return this.dir;
    }

    public UninstallRule dir(String dir) {
        this.setDir(dir);
        return this;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    @StorableDoc(value="Matches against the relative(related to the dir property) path. Folders end with an /. \"include\":[\"[^/].*\"] matches all files within #dir, but not #dir.  A list of regular expressions. If any expression matches a relative path (incl. Dynamic Links), the path will NOT get uninstalled - even if there is a matching include rule.")
    @StorableExample(value="[\"\\\\.\\\\%INSTALL_ROOT[/\\\\\\\\]config[/\\\\\\\\].*\"]")
    public String[] getExclude() {
        return this.exclude;
    }

    public UninstallRule exclude(String[] exclude) {
        this.setExclude(exclude);
        return this;
    }

    public void setExclude(String[] exclude) {
        this.exclude = exclude;
    }

    @StorableDoc(value="Matches against the relative(related to the dir property) path. Folders end with an /. \"include\":[\"[^/].*\"] matches all files within #dir, but not #dir. A list of regular expressions. Only relative paths (incl. Dynamic Links), that match at least one expression will get uninstalled. The default rule is .* and matches everything. Excludes are exceptions to includes, so if there is a matching include AND exclude rule, the file will NOT get removed")
    @StorableExample(value="\"[^/]+\"")
    public String[] getInclude() {
        return this.include;
    }

    public PreCondition[] getConditions() {
        return this.conditions;
    }

    public void setConditions(PreCondition[] conditions) {
        this.conditions = conditions;
    }

    public void setInclude(String[] include) {
        this.include = include;
    }
}

