/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange.setup;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.appwork.remoteapi.annotations.AllowNonStorableObjects;
import org.appwork.storage.BuildsInfo;
import org.appwork.storage.FailLevel;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAvailableSince;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.StorableExample;
import org.appwork.storage.StorableHidden;
import org.appwork.storage.StorableValidateCondition;
import org.appwork.storage.StorableValidateNotNull;
import org.appwork.storage.StorableValidateTimeSpan;
import org.appwork.storage.TypeRef;
import org.appwork.txtresource.LocaleMap;
import org.appwork.updatesys.transport.exchange.UninstallInfo;
import org.appwork.updatesys.transport.exchange.setup.ApplicationLauncher;
import org.appwork.updatesys.transport.exchange.setup.CmdHook;
import org.appwork.updatesys.transport.exchange.setup.DoNotTouchPathEntry;
import org.appwork.updatesys.transport.exchange.setup.DynLink;
import org.appwork.updatesys.transport.exchange.setup.ProcessReference;
import org.appwork.updatesys.transport.exchange.signature.Signature;
import org.appwork.utils.duration.TimeSpan;

@AllowNonStorableObjects(value={Date.class})
public class RepoStorable
implements Storable {
    public static final TypeRef<RepoStorable> TYPE = new TypeRef<RepoStorable>(RepoStorable.class){};
    public String _id;
    private String action;
    private TimeSpan checkInterval;
    private TimeSpan delayAfterClickingLater;
    private LocaleMap displayNames;
    private ArrayList<String> doNotDeletePathes;
    private ArrayList<DoNotTouchPathEntry> doNotTouchPathes;
    private TimeSpan forceConnectionWarningDialogTimeout;
    private String group;
    private String namespace;
    private List<DynLink> pathLinks;
    private List<ProcessReference> processes;
    int progressMultiplicator = 1;
    private String publicSignatureKey;
    private String repoName;
    private Signature signature;
    private TimeSpan silentTimeAfterCancelProxyDialog;
    private String sortOn;
    private UninstallInfo uninstall;
    private String[] updateServers;
    private String rootPath;
    @StorableDoc(value="Hooks can be used to execute applications or scripts when a certain trigger matches.")
    @StorableAvailableSince(value="2022-06-27T17:42+0200")
    private List<CmdHook> hooks;
    private boolean userAllowedToReinstall = false;
    private List<ApplicationLauncher> applicationLaunchers;
    private boolean userAllowedToUninstall = false;
    private BuildsInfo targetBuilds;

    public List<CmdHook> getHooks() {
        return this.hooks;
    }

    public void setHooks(List<CmdHook> hooks) {
        this.hooks = hooks;
    }

    public void setUserAllowedToReinstall(boolean userAllowedToReinstall) {
        this.userAllowedToReinstall = userAllowedToReinstall;
    }

    public void setUserAllowedToUninstall(boolean userAllowedToUninstall) {
        this.userAllowedToUninstall = userAllowedToUninstall;
    }

    public void setApplicationLaunchers(List<ApplicationLauncher> applicationLaunchers) {
        this.applicationLaunchers = applicationLaunchers;
    }

    @StorableAvailableSince(value="2023-06-27T00:00+0200")
    @StorableDoc(value="If you want to start your applications from the Connect (Context) menu or tray menu, define the required information here.")
    public List<ApplicationLauncher> getApplicationLaunchers() {
        return this.applicationLaunchers;
    }

    @StorableAvailableSince(value="2023-05-05T00:00+0200")
    @StorableDoc(value="If false, Reinstall buttons/menus will not be visible, even if uninstall rules are available. Uninstall requests from other origins like 'Offline Packages', 'Dynamic Server-managed Repositories',... are unaffected.")
    public boolean isUserAllowedToReinstall() {
        return this.userAllowedToReinstall;
    }

    @StorableAvailableSince(value="2023-05-05T00:00+0200")
    @StorableDoc(value="If false, Uninstall buttons/menus will not be visible, even if uninstall rules are available. Uninstall requests from other origins like 'Offline Packages', 'Dynamic Server-managed Repositories',... are unaffected.")
    public boolean isUserAllowedToUninstall() {
        return this.userAllowedToUninstall;
    }

    @StorableAvailableSince(value="2023-02-24T16:26+0200", level=FailLevel.INFO)
    @StorableDoc(value="Information about the target Clients this configuration should be used with. This information is used to create warnings or to avoid that unsupported or deprectaed features are used.")
    @StorableValidateNotNull(description="It is recommended to set up a proper targetClients property.", level=FailLevel.WARNING)
    public BuildsInfo getTargetBuilds() {
        return this.targetBuilds;
    }

    public void setTargetBuilds(BuildsInfo clientInfo) {
        this.targetBuilds = clientInfo;
    }

    @StorableDoc(value="Reserved. Leave empty")
    @StorableHidden
    public String get_id() {
        return this._id;
    }

    @StorableDoc(value="Reserved. Leave empty")
    @StorableHidden
    public String getAction() {
        return this.action;
    }

    @StorableDoc(value="How often shall Connect check this repository for updates.")
    @StorableExample(value="\"10m\"")
    @StorableValidateTimeSpan(min="1m", max="1W")
    public TimeSpan getCheckInterval() {
        if (this.checkInterval == null) {
            this.checkInterval = TimeSpan.MINUTES_10;
        }
        return this.checkInterval;
    }

    @StorableDoc(value="How long shall Connect wait for a recheck if the user clicked 'Install later'")
    @StorableExample(value="\"1h\"")
    @StorableValidateTimeSpan(min="1m", max="1W")
    public TimeSpan getDelayAfterClickingLater() {
        if (this.delayAfterClickingLater == null) {
            this.delayAfterClickingLater = TimeSpan.HOURS_1;
        }
        return this.delayAfterClickingLater;
    }

    @StorableDoc(value="The display name of the repository. Use this property instead of 'readableName'")
    @StorableExample(value="{\"en\":\"My Software\",\"de\":\"Meine Software\"}")
    @StorableAvailableSince(value="2020-06-24T00:00+0200", message="Replaces 'readableName'.Use 'readableName' as well if you need to support older clients")
    @StorableValidateNotNull
    public LocaleMap getDisplayNames() {
        return this.displayNames;
    }

    public static void main(String[] args) {
        System.out.println(".%CONNECT\\test\\abc.exe".matches(".%CONNECT[/\\\\].*\\.exe$"));
        System.out.println(JSonStorage.serializeToJson(JSonStorage.serializeToJson(".%CONNECT[/\\\\].*\\.exe$")));
    }

    @StorableDoc(value="A list of paths regular expressions that cannot be removed, even if the server asks so. .% DynLinks can be used.")
    @StorableExample(value="[\".%CONNECT[/\\\\\\\\].*\\\\.exe$\"]")
    public ArrayList<String> getDoNotDeletePathes() {
        return this.doNotDeletePathes;
    }

    @StorableDoc(value="This property can be used to protect important paths. Protected paths cannot be modified, even if the server asks so.")
    public ArrayList<DoNotTouchPathEntry> getDoNotTouchPathes() {
        return this.doNotTouchPathes;
    }

    @StorableDoc(value="If Connect could not reach the server for more than forceConnectionWarningDialogTimeout milliseconds, Connect will ask the user for a proper connection setup.")
    @StorableExample(value="\"7D\"")
    @StorableValidateTimeSpan(min="1D", max="1Y")
    public TimeSpan getForceConnectionWarningDialogTimeout() {
        if (this.forceConnectionWarningDialogTimeout == null) {
            this.forceConnectionWarningDialogTimeout = TimeSpan.WEEKS_1;
        }
        return this.forceConnectionWarningDialogTimeout;
    }

    @StorableDoc(value="The staging group. null for 'all others'. The group must  case sensitive match a group defined in the admintool or null.")
    @StorableExample(value="\"ALPHA\"")
    public String getGroup() {
        return this.group;
    }

    @StorableDoc(value="A absolute unique identifier accross all servers. By default this is <reponame>@<domain[0]>. The namespace is used to store all repository related information.")
    @StorableExample(value="\"MY_UNIQUE_REPO_ID\"")
    @StorableValidateCondition(value="{\"\u00a7regex\":\"^\\\\S{2}\\\\S*\\\\S$\"}", description="At least 3 characters, no whitespaces")
    public String getNamespace() {
        return this.namespace;
    }

    @StorableDoc(value="A list to define the Dynamic Paths linking. ")
    @StorableExample(value="[{}]")
    public List<DynLink> getPathLinks() {
        return this.pathLinks;
    }

    @StorableExample(value="[{}]")
    @StorableDoc(value="A list of proccesses that must be blocked on closed during installation")
    public List<ProcessReference> getProcesses() {
        return this.processes;
    }

    @StorableExample(value="1")
    @StorableDoc(value="A multiplicator used for aggregated progress calculation. If set to 2, the repository will get weighted 200%")
    public int getProgressMultiplicator() {
        return this.progressMultiplicator;
    }

    @StorableDoc(value="The repository public key in Base64 format")
    @StorableExample(value="\"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAlb+iF7mLa2dYrTn/O2M2p3ofu+bhMFQiko39ilOeSOn9RKlEKiaN5U0rhCyyd0YVaf3dZIgdVvU+IXEO5cKuVNwkyODpXcUevCedBRewHHcGAXmYUB7m0GYs9zsdjoC6jshxQqvYDpdwFhBOMBebctAZeiVKjPISc2MZ5HZufZlbSPBeCxnE4+IalL+Z3tigAr0mvZau/upyUPu6wveaVYdSm219gkzQ2lCybPdvCsWR3lhFLgCQeVHUmOP8K7khEGRFsmbQvytQZpTVnY7FzjZ2dYU4xT6a2Vwfds2gMzoiOdbdIaQ7xqDvreWsFCCO7un2cUTB3f93UIsVaNd4xwIDAQAB\"")
    public String getPublicSignatureKey() {
        return this.publicSignatureKey;
    }

    @StorableExample(value="\"MY_REPO\"")
    @StorableDoc(value="The repository id.  - must match the server id.")
    @StorableValidateCondition(value="{\"\u00a7regex\":\"^\\\\S{3,}$\"}", description="At least 3 characters, no whitespaces")
    public String getRepoName() {
        return this.repoName;
    }

    @StorableDoc(value="The installation root. default: Connect installation directory. Can be ignored if you use only Dynamic Paths.")
    @StorableExample(value="null")
    public String getRootPath() {
        return this.rootPath;
    }

    @StorableDoc(value="Reserved for Dynamic Repos")
    @StorableHidden
    public Signature getSignature() {
        return this.signature;
    }

    @StorableDoc(value="Connect does not ask for a proxy for the given time after the user canceled the dialog")
    @StorableExample(value="\"1D\"")
    public TimeSpan getSilentTimeAfterCancelProxyDialog() {
        if (this.silentTimeAfterCancelProxyDialog == null) {
            this.silentTimeAfterCancelProxyDialog = TimeSpan.HOURS_12;
        }
        return this.silentTimeAfterCancelProxyDialog;
    }

    @StorableExample(value="\"003\"")
    @StorableDoc(value="Defines the order (alphabetic) of the repositories in the main table. By default, the repoName is used.")
    public String getSortOn() {
        return this.sortOn;
    }

    @StorableDoc(value="a ruleset that defines which actions have to be performed on uninstallation.")
    @StorableExample(value="{}")
    public UninstallInfo getUninstall() {
        return this.uninstall;
    }

    @StorableDoc(value="A list of the updateserver endpoint and its mirrors")
    @StorableExample(value="[\"https://update.appwork.org/jcgi/\"]")
    @StorableValidateCondition(value="{\"\u00a7each\":{\"\u00a7regex\":\"^https?://.+$\"}}")
    public String[] getUpdateServers() {
        return this.updateServers;
    }

    public void set_id(String _id) {
        this._id = _id;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setCheckInterval(TimeSpan checkInterval) {
        this.checkInterval = checkInterval;
    }

    public void setDelayAfterClickingLater(TimeSpan delay) {
        this.delayAfterClickingLater = delay;
    }

    public void setDisplayNames(LocaleMap readableName) {
        this.displayNames = readableName;
    }

    public void setDoNotDeletePathes(ArrayList<String> doNotDeletePathes) {
        this.doNotDeletePathes = doNotDeletePathes;
    }

    public void setDoNotTouchPathes(ArrayList<DoNotTouchPathEntry> doNotTouchPathes) {
        this.doNotTouchPathes = doNotTouchPathes;
    }

    public void setForceConnectionWarningDialogTimeout(TimeSpan forceConnectionWarningDialogTimeout) {
        this.forceConnectionWarningDialogTimeout = forceConnectionWarningDialogTimeout;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPathLinks(List<DynLink> pathLinks) {
        this.pathLinks = pathLinks;
    }

    public void setProcesses(List<ProcessReference> lockedApplicationsDuringInstallation) {
        this.processes = lockedApplicationsDuringInstallation;
    }

    public void setProgressMultiplicator(int progressMultiplicator) {
        this.progressMultiplicator = progressMultiplicator;
    }

    public void setPublicSignatureKey(String publicKey) {
        this.publicSignatureKey = publicKey;
    }

    public void setRepoName(String repoName) {
        this.repoName = repoName;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    public void setSilentTimeAfterCancelProxyDialog(TimeSpan silentTimeAfterCancelProxyDialog) {
        this.silentTimeAfterCancelProxyDialog = silentTimeAfterCancelProxyDialog;
    }

    public void setSortOn(String sortOn) {
        this.sortOn = sortOn;
    }

    public void setUninstall(UninstallInfo uninstall) {
        this.uninstall = uninstall;
    }

    public void setUpdateServers(String[] updateServers) {
        this.updateServers = updateServers;
    }
}

