/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange.setup;

import org.appwork.storage.Storable;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.StorableExample;
import org.appwork.storage.StorableValidateCondition;

@StorableDoc(value="Dynamic Link to map a .%.. relative path to a local absolute path. Check the WIKI for predefined Dynamic Links and use them where possible.")
public class DynLink
implements Storable {
    private String key;
    private String folder;

    @StorableExample(value="\".%ROOT\"")
    @StorableDoc(value="The key must start with .%!")
    @StorableValidateCondition(value="{\u00a7regex:^\\\\.\\\\%\\\\S+$}", description="Must start with .% followed by an id without whitespace")
    public String getKey() {
        return this.key;
    }

    public DynLink key(String key) {
        this.setKey(key);
        return this;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @StorableExample(value="\"c:/programfiles/myistallation\"")
    @StorableDoc(value="The folder can either be an absolute path, or start with another dynamic link key (e.g. a predefined one).")
    @StorableValidateCondition(value="{\u00a7size:{\u00a7gt:0}}", description="Absolute (c:/*) or Dynamic path (.%*)")
    public String getFolder() {
        return this.folder;
    }

    public DynLink folder(String folder) {
        this.setFolder(folder);
        return this;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }
}

