/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange.setup;

import java.util.regex.Pattern;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.StorableExample;
import org.appwork.updatesys.transport.exchange.setup.OnMatchAction;

@StorableDoc(value="A rule to ensure that files or folders to not get modified, even if the server requests a modification")
public class DoNotTouchPathEntry
implements Storable {
    private String pattern;
    private OnMatchAction onMatchAction = OnMatchAction.ERROR;
    private Pattern _pattern;

    @StorableDoc(value="A regular expression that must match the relativ path of a file or folder")
    @StorableExample(value="\".%CONNECT[/\\\\\\\\].*\\\\.exe$\"")
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @StorableDoc(value="The action that should be performed on case of a match. ERROR (The installation stops and changes will get reverted) or SKIP(The installation will continue without the affected path)")
    @StorableExample(value="\"ERROR\"")
    public OnMatchAction getOnMatchAction() {
        if (this.onMatchAction == null) {
            return OnMatchAction.ERROR;
        }
        return this.onMatchAction;
    }

    public void setOnMatchAction(OnMatchAction onMatchAction) {
        this.onMatchAction = onMatchAction;
    }

    public Pattern _getPattern() {
        if (this._pattern != null) {
            return this._pattern;
        }
        this._pattern = Pattern.compile(this.getPattern());
        return this._pattern;
    }
}

