/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange.releaseInfo;

import org.appwork.storage.Storable;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.StorableExample;
import org.appwork.storage.StorableSee;
import org.appwork.storage.StorableTypeAlternatives;
import org.appwork.storage.StorableValidateMandatoryInJson;
import org.appwork.storage.StorableValidateNotNull;
import org.appwork.storage.TypeRef;
import org.appwork.updatesys.transport.exchange.releaseInfo.LinkContent;
import org.appwork.updatesys.transport.exchange.releaseInfo.ReleaseInfoEntryType;
import org.appwork.utils.reflection.CompiledType;

public class ReleaseInfoEntry<Content>
implements Storable {
    public static final CompiledType TYPE_STRING = CompiledType.create(new TypeRef<ReleaseInfoEntry<String>>(){});
    public static final CompiledType TYPE_LINK = CompiledType.create(new TypeRef<ReleaseInfoEntry<LinkContent>>(){});
    @StorableDoc(value="The content of the entry. The actual value and syntax of this property depends on the selected type.")
    @StorableSee(value={ReleaseInfoEntryType.class})
    @StorableTypeAlternatives(value={String.class, LinkContent.class})
    @StorableValidateNotNull
    @StorableValidateMandatoryInJson
    private Content content;
    @StorableDoc(value="The label(left aligned text in the MultiConnect dropdown) of the entry. If null, the entry will span over the complete available width. If \"\", there will be no label, but the entry will only span the right column. ")
    @StorableExample(value="\"Description\"")
    private String label;
    @StorableDoc(value="The type of the entry.")
    @StorableValidateNotNull
    @StorableValidateMandatoryInJson
    @StorableExample(value="\"TEXT\"")
    private ReleaseInfoEntryType type;

    public ReleaseInfoEntry() {
    }

    public ReleaseInfoEntry(ReleaseInfoEntryType type, Content text) {
        this.type = type;
        this.content = text;
    }

    public Content getContent() {
        return this.content;
    }

    public String getLabel() {
        return this.label;
    }

    public ReleaseInfoEntryType getType() {
        return this.type;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setType(ReleaseInfoEntryType type) {
        this.type = type;
    }
}

