/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange.batch;

import org.appwork.storage.Storable;
import org.appwork.storage.TypeRef;
import org.appwork.updatesys.transport.exchange.batch.BatchRequest;
import org.appwork.updatesys.transport.exchange.batch.BatchResponse;
import org.appwork.updatesys.transport.exchange.batch.JobResponse;
import org.appwork.updatesys.transport.exchange.batch.JobResponseCallback;
import org.appwork.utils.UniqueAlltimeID;

public class JobRequest
implements Storable {
    private String json;
    private long id = 0L;
    private String name;
    private JobResponse _response;
    private Object deserialized;
    private JobResponseCallback responseCallback;

    public String getJson() {
        return this.json;
    }

    public JobRequest json(String json) {
        this.setJson(json);
        return this;
    }

    public String toString() {
        return this.name + ": " + this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public JobRequest() {
    }

    public JobRequest(String name) {
        this.name = name;
        this.json = null;
    }

    public JobRequest(String name, Object parameter) {
        this.name = name;
        this.json = BatchRequest.MAPPER.objectToString(parameter);
    }

    public long getId() {
        return this.id;
    }

    public JobRequest id(long id) {
        this.setId(id);
        return this;
    }

    public void setId(long id) {
        this.id = id;
    }

    public JobResponse _getResponse() {
        return this._response;
    }

    public String getName() {
        return this.name;
    }

    public JobRequest name(String name) {
        this.setName(name);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JobRequest withID() {
        if (this.getId() == 0L) {
            return this.id(UniqueAlltimeID.next());
        }
        return this;
    }

    public void onResponse(JobResponse es) {
        this._response = es;
        JobResponseCallback responseCallback = this.responseCallback;
        if (responseCallback != null) {
            responseCallback.onResponse(this);
        }
    }

    public JobRequest responseCallback(JobResponseCallback responseCallback) {
        this.withID();
        this.responseCallback = responseCallback;
        return this;
    }

    public <T> T restoreParameter(TypeRef<T> type) {
        if (this.getJson() == null) {
            return null;
        }
        if (this.deserialized == null) {
            this.deserialized = BatchResponse.MAPPER.stringToObject(this.getJson(), type);
        }
        return (T)this.deserialized;
    }
}

