/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.appwork.updatesys.transport.exchange.DiskSpaceChanges;
import org.appwork.updatesys.transport.exchange.DownloadMirror;
import org.appwork.updatesys.transport.exchange.DownloadUrlList;
import org.appwork.updatesys.transport.exchange.ResponseStatus;
import org.appwork.updatesys.transport.exchange.ServerResponse;
import org.appwork.updatesys.transport.exchange.interfaces.WaitResponseInterface;
import org.appwork.updatesys.transport.exchange.json.WaitJsonResponse;

public class WaitResponse
extends ServerResponse
implements WaitResponseInterface {
    private final int destRevision;
    private final long checkInterval;
    private final long eta;
    private String changeLogHash = null;
    private long changeLogSize = -1L;
    private long changeLogContentSize = -1L;
    private DownloadUrlList changeLogURLs = null;
    private final DownloadUrlList changeLogURLsBackup = new DownloadUrlList();
    private String changelogText;

    @Override
    public Map<String, DiskSpaceChanges> getDiskSpaceChanges() {
        return null;
    }

    @Override
    public String getChangeLogText() {
        return this.changelogText;
    }

    public WaitResponse(int destRevision, long checkInterval, long eta) {
        super(ResponseStatus.WAIT);
        this.destRevision = destRevision;
        this.checkInterval = checkInterval;
        this.eta = eta;
    }

    public WaitResponse(String[] lines) throws NumberFormatException, MalformedURLException {
        super(ResponseStatus.WAIT);
        this.destRevision = Integer.parseInt(lines[1]);
        this.checkInterval = Long.parseLong(lines[2]);
        this.eta = Long.parseLong(lines[3]);
        if (lines.length >= 5) {
            String[] changeLogInfos = lines[4].split(";");
            this.setChangeLog(changeLogInfos[0], Long.parseLong(changeLogInfos[1]), Long.parseLong(changeLogInfos[2]), DownloadUrlList.parse(Arrays.copyOfRange(changeLogInfos, 3, changeLogInfos.length)));
        }
    }

    @Override
    public long getChangeLogContentSize() {
        return this.changeLogContentSize;
    }

    @Override
    public String getChangeLogHash() {
        return this.changeLogHash;
    }

    @Override
    public long getChangeLogSize() {
        return this.changeLogSize;
    }

    @Override
    public DownloadUrlList getChangeLogUrls() {
        return this.changeLogURLs;
    }

    @Override
    public long getCheckInterval() {
        return this.checkInterval;
    }

    @Override
    public int getDestRevision() {
        return this.destRevision;
    }

    @Override
    public long getEta() {
        if (this.eta == 5000L) {
            return -1L;
        }
        return this.eta;
    }

    @Override
    public Object[] getFields() {
        if (this.changeLogURLs != null && this.changeLogURLs.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.changeLogHash);
            sb.append(";");
            sb.append(this.changeLogSize);
            sb.append(";");
            sb.append(this.changeLogContentSize);
            for (DownloadMirror changeLogMirror : this.changeLogURLs) {
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(changeLogMirror.toString());
            }
            return new Object[]{this.destRevision, this.checkInterval, this.eta, sb.toString()};
        }
        return new Object[]{this.destRevision, this.checkInterval, this.eta};
    }

    public void resetChangeLogUrls() {
        DownloadUrlList tmp = new DownloadUrlList();
        tmp.addAll(this.changeLogURLsBackup);
        if (tmp.size() > 0) {
            this.changeLogURLs = tmp;
        }
    }

    public void setChangeLog(String hash, long size, long contentSize, DownloadUrlList urls) {
        this.changeLogURLsBackup.clear();
        if (urls != null && urls.size() > 0) {
            this.changeLogURLs = urls;
            this.changeLogURLsBackup.addAll(this.changeLogURLs);
            this.changeLogHash = hash;
            this.changeLogSize = size;
            this.changeLogContentSize = contentSize;
        } else {
            this.changeLogURLs = null;
            this.changeLogHash = null;
            this.changeLogSize = -1L;
            this.changeLogContentSize = -1L;
        }
    }

    @Override
    public void setChangeLogText(String txt) {
        this.changelogText = txt;
    }

    @Override
    public List<String> getUpdateFlags() {
        return null;
    }

    @Override
    public String getRevisionName() {
        return null;
    }

    @Override
    public WaitJsonResponse toJsonVariant() {
        return new WaitJsonResponse(this);
    }
}

