/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import java.util.Date;
import java.util.List;
import org.appwork.remoteapi.annotations.AllowNonStorableObjects;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAvailableSince;
import org.appwork.storage.StorableDeprecatedSince;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.StorableExample;
import org.appwork.storage.TypeRef;
import org.appwork.updatesys.transport.exchange.Exec;
import org.appwork.updatesys.transport.exchange.setup.UninstallRule;
import org.appwork.utils.os.CrossSystem;

@StorableDoc(value="A ruleset to define which actions must be executed durin uninstallation of a repository")
@AllowNonStorableObjects(value={Date.class})
public class UninstallInfo
implements Storable {
    public static final TypeRef<UninstallInfo> TYPE = new TypeRef<UninstallInfo>(UninstallInfo.class){};
    private List<ExecuteRule> execute;
    private List<Exec> executes;
    private List<UninstallRule> rules;

    @StorableDoc(value="Execute a Script, Connect Service package or commandline")
    @StorableAvailableSince(value="2022-10-12T09:10+0200", message="use execute for older clients")
    public List<Exec> getExecutes() {
        return this.executes;
    }

    public void setExecutes(List<Exec> executes) {
        this.executes = executes;
    }

    @StorableDoc(value="A List of Execute Rules")
    @StorableExample(value="[{}]")
    @StorableDeprecatedSince(value="2022-10-12T09:10+0200", message="Use 'executes' instead.")
    @Deprecated
    public List<ExecuteRule> getExecute() {
        return this.execute;
    }

    public void setExecute(List<ExecuteRule> execute) {
        this.execute = execute;
    }

    @StorableDoc(value="A List of Directory Rules")
    @StorableExample(value="[{}]")
    public List<UninstallRule> getRules() {
        return this.rules;
    }

    public void setRules(List<UninstallRule> rules) {
        this.rules = rules;
    }

    @StorableDoc(value="An Executerule contains all information to execute a binary that contains uninstall instructions")
    @Deprecated
    @StorableDeprecatedSince(value="2022-10-12T09:10+0200", message="Use 'executes' instead.")
    public static class ExecuteRule
    implements Storable {
        private CrossSystem.OSFamily os;
        private String[] cmd;
        private String dir;

        @StorableDoc(value="The target operating system. The value must be a member of the OSFamily enum - e.g.  BSD,LINUX,MAC,OS2,OTHERS,WINDOWS")
        @StorableExample(value="\"WINDOWS\"")
        public CrossSystem.OSFamily getOs() {
            return this.os;
        }

        public void setOs(CrossSystem.OSFamily os) {
            this.os = os;
        }

        @StorableDoc(value="The 'run-in' directory - dynamic .% pathes are allowed")
        @StorableExample(value="\".%repoconfig\"")
        public String getDir() {
            return this.dir;
        }

        public void setDir(String dir) {
            this.dir = dir;
        }

        @StorableDoc(value="The shell commandline to execute the binary - dynamic .% pathes are allowed")
        @StorableExample(value="[\"cmd\",\"/c\",\".%repoconfig/uninstall.bat\"]")
        public String[] getCmd() {
            return this.cmd;
        }

        public void setCmd(String[] cmd) {
            this.cmd = cmd;
        }
    }
}

