/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import org.appwork.storage.Storable;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.StorableHidden;
import org.appwork.storage.TypeRef;
import org.appwork.utils.StringUtils;

public class Revision
implements Storable {
    public static final TypeRef<Revision> TYPE = new TypeRef<Revision>(Revision.class){};
    public static final Revision NO_REVISION = new Revision(-1);
    private String changelog = null;
    @StorableDoc(value="The internal revision id")
    private int id = 0;
    @StorableHidden
    private String tag = null;
    private String name = null;

    public Revision() {
    }

    public Revision(int id) {
        this.id = id;
    }

    public Revision(int id, String name) {
        this(id, name, null);
    }

    public Revision(int id, String name, String changelog) {
        this.id = id;
        this.name = name;
        this.changelog = changelog;
    }

    @StorableDoc(value="The current release info text")
    public String getChangelog() {
        return this.changelog;
    }

    public void setChangelog(String changelog) {
        this.changelog = changelog;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String toString() {
        return String.valueOf(this.getId());
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @StorableDoc(value="The revision name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String _getNameOrID() {
        String name = this.getName();
        int id = this.getId();
        if (StringUtils.isNotEmpty(name)) {
            return name;
        }
        if (id <= 0) {
            return "-";
        }
        return String.valueOf(id);
    }

    public boolean _isNewerThan(Revision revision) {
        return this.getId() > revision.getId();
    }

    public boolean _hasName() {
        return StringUtils.isNotEmpty(this.getName());
    }

    public boolean _isValid() {
        return this.getId() > 0;
    }

    public Revision _getNewest(Revision ... revisions) {
        Revision ret = this;
        for (Revision r : revisions) {
            if (!r._isNewerThan(ret)) continue;
            ret = r;
        }
        return ret;
    }

    public String _getNameAndID() {
        if (this._hasName()) {
            return this.getName() + "(" + (this.getId() <= 0 ? "-" : Integer.valueOf(this.getId())) + ")";
        }
        return String.valueOf(this.getId() <= 0 ? "-" : Integer.valueOf(this.getId()));
    }
}

