/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.crypto.AWSign;
import org.appwork.utils.crypto.SignatureViolationException;
import org.appwork.utils.encoding.Base64;

public class RemovedFile {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final boolean file;
    private final int signatureRevision;
    private final String signaturePath;
    private byte[] signature;

    public RemovedFile(boolean isFile, int revision, String rel) {
        this.file = isFile;
        this.signatureRevision = revision;
        if (rel.endsWith("/")) {
            rel = rel.substring(0, rel.length() - 1);
        }
        this.signaturePath = rel;
    }

    public RemovedFile(File f) throws IOException {
        this(IO.readFileToTrimmedString(f));
    }

    public RemovedFile(String signatureString) {
        String[] lines = Regex.getLines(signatureString);
        this.file = lines[0].equals("F");
        this.signatureRevision = Integer.parseInt(lines[1]);
        this.signature = Base64.decode(lines[2]);
        this.signaturePath = null;
    }

    public byte[] create(PrivateKey privateKey) throws UnsupportedEncodingException, SignatureViolationException {
        if (this.signaturePath == null) {
            throw new IllegalStateException("path is null");
        }
        String toSign = (this.file ? "F" : "D") + "\r\n" + this.signatureRevision + "\r\n" + this.signaturePath;
        this.signature = AWSign.createSign(toSign.getBytes(UTF8), privateKey, true);
        StringBuilder sb = new StringBuilder();
        sb.append(this.isFile() ? "F" : "D");
        sb.append("\r\n");
        sb.append(this.signatureRevision);
        sb.append("\r\n");
        sb.append(Base64.encodeToString(this.signature, false));
        return sb.toString().getBytes(UTF8);
    }

    public boolean isFile() {
        return this.file;
    }

    public void verify(int verifyRevision, String verifyPath, PublicKey publicKey) throws UnsupportedEncodingException, SignatureViolationException {
        String toSign = (this.isFile() ? "F" : "D") + "\r\n" + verifyRevision + "\r\n" + verifyPath;
        try {
            if (this.signatureRevision != -1 && this.signatureRevision != verifyRevision) {
                throw new SignatureViolationException("revision mismatch");
            }
            if (this.signature == null || this.signature.length == 0) {
                throw new SignatureViolationException("empty signature");
            }
            AWSign.verify(toSign.getBytes(UTF8), publicKey, this.signature, true);
        }
        catch (SignatureViolationException e) {
            if (e.getCause() == null) {
                throw new SignatureViolationException(verifyRevision + "@" + this.signatureRevision + "@" + verifyPath + "|" + e.getMessage());
            }
            throw new SignatureViolationException(verifyRevision + "@" + this.signatureRevision + "@" + verifyPath, e.getCause());
        }
    }
}

