/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.appwork.updatesys.transport.exchange.LicenseCode;
import org.appwork.updatesys.transport.exchange.ResponseStatus;
import org.appwork.updatesys.transport.exchange.ServerResponse;
import org.appwork.updatesys.transport.exchange.json.ServerJsonResponse;

public class LicenseResponse
extends ServerResponse {
    private final LicenseCode licenseCode;
    private byte[] license;
    private long creationTimeStamp;
    private long expireTimeStamp = System.currentTimeMillis() + 1209600000L;
    private String signature;

    public byte[] getLicense() {
        return this.license;
    }

    public long getCreationTimeStamp() {
        return this.creationTimeStamp;
    }

    public long getExpireTimeStamp() {
        return this.expireTimeStamp;
    }

    public String getSignature() {
        return this.signature;
    }

    public LicenseCode getLicenseCode() {
        return this.licenseCode;
    }

    public LicenseResponse(LicenseCode licenseCode, byte[] license, long creationTimeStamp, long expireTimeStamp, String signature) {
        super(ResponseStatus.LIC1);
        this.licenseCode = licenseCode;
        this.license = license;
        this.creationTimeStamp = creationTimeStamp;
        this.expireTimeStamp = expireTimeStamp;
        this.signature = signature;
    }

    @Override
    public Object[] getFields() {
        return null;
    }

    public LicenseResponse(String[] lines) throws NumberFormatException, UnsupportedEncodingException {
        super(ResponseStatus.LIC1);
        this.licenseCode = LicenseCode.valueOf(lines[1]);
        if (LicenseCode.VALID.equals((Object)this.getLicenseCode())) {
            this.license = lines[2].getBytes("UTF-8");
            this.creationTimeStamp = Long.parseLong(lines[3]);
            this.expireTimeStamp = Long.parseLong(lines[4]);
            this.signature = lines[5];
        }
    }

    @Override
    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(this.getStatus().name().getBytes("UTF-8"));
        byte[] NL = "\r\n".getBytes("UTF-8");
        os.write(NL);
        switch (this.getLicenseCode()) {
            case UNAVAILABLE: 
            case UNKNOWN: 
            case INVALID: {
                os.write(this.getLicenseCode().name().getBytes("UTF-8"));
                break;
            }
            case VALID: {
                os.write(this.getLicenseCode().name().getBytes("UTF-8"));
                os.write(NL);
                os.write(this.getLicense());
                os.write(NL);
                os.write(String.valueOf(this.getCreationTimeStamp()).getBytes("UTF-8"));
                os.write(NL);
                os.write(String.valueOf(this.getExpireTimeStamp()).getBytes("UTF-8"));
                os.write(NL);
                os.write(this.getSignature().getBytes("UTF-8"));
            }
        }
        return os.toByteArray();
    }

    @Override
    public int _getBatchRequiredProtocolVersion() {
        return Integer.MAX_VALUE;
    }

    @Override
    public ServerJsonResponse toJsonVariant() {
        return null;
    }
}

