/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import java.util.Arrays;
import java.util.List;
import org.appwork.updatesys.transport.exchange.ResponseStatus;
import org.appwork.updatesys.transport.exchange.ServerResponse;
import org.appwork.updatesys.transport.exchange.interfaces.IDsResponseInterface;
import org.appwork.updatesys.transport.exchange.json.IDsJsonResponse;
import org.appwork.updatesys.transport.exchange.json.ServerJsonResponse;

public class IDsResponse
extends ServerResponse
implements IDsResponseInterface {
    private final int destRevision;
    private final List<String> ids;

    public IDsResponse(int destRevision, List<String> ids) {
        super(ResponseStatus.IDS);
        this.destRevision = destRevision;
        this.ids = ids;
    }

    public IDsResponse(String[] lines) throws NumberFormatException {
        super(ResponseStatus.IDS);
        this.destRevision = Integer.parseInt(lines[1]);
        this.ids = lines.length >= 3 ? Arrays.asList(lines[2].split(",")) : null;
    }

    @Override
    public int getDestRevision() {
        return this.destRevision;
    }

    @Override
    public Object[] getFields() {
        if (this.ids != null && this.ids.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String id : this.ids) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(id);
            }
            return new Object[]{this.destRevision, sb.toString()};
        }
        return new Object[]{this.destRevision};
    }

    @Override
    public List<String> getIds() {
        return this.ids;
    }

    @Override
    public String getRevisionName() {
        return null;
    }

    @Override
    public ServerJsonResponse toJsonVariant() {
        return new IDsJsonResponse(this);
    }
}

