/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import java.util.List;
import org.appwork.storage.FailLevel;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAvailableSince;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.StorableExample;
import org.appwork.storage.StorableLink;
import org.appwork.storage.StorableSee;
import org.appwork.storage.StorableValidateCondition;
import org.appwork.storage.StorableValidateCondition2;
import org.appwork.storage.StorableValidateCondition3;
import org.appwork.storage.StorableValidateRegex;
import org.appwork.storage.StorableValidationLogic;
import org.appwork.txtresource.LocaleMap;
import org.appwork.updatesys.transport.exchange.ElevationMode;
import org.appwork.updatesys.transport.exchange.ExecuteResultMapping;
import org.appwork.updatesys.transport.exchange.setup.GenericConditionMatcher;
import org.appwork.updatesys.transport.exchange.setup.PreCondition;
import org.appwork.utils.duration.TimeSpan;

@StorableAvailableSince(value="2022-06-27T17:42+0200")
public class Exec
implements Storable {
    @StorableDoc(value="If you have entries in the repo_*.json.processes list, these processes will get locked and you cannot access, modify, execute, delete them. If you need to work on them, add them to this list")
    private String[] allowAccess;
    @StorableValidateCondition(value="{\u00a7ne:null}", description="Must not be null")
    @StorableValidateCondition2(value="{\u00a7or:[{\u00a7eq:[]},{\u00a7exists:true,\u00a7ne:null,\u00a7in:[null,\"\"]}]}", logic=StorableValidationLogic.FAIL_ON_MATCH, description="cmd must contain at least one entry, but no empty or null entries")
    @StorableValidateCondition3(value="{\u00a7any:{\u00a7regex:\".*\\\\%[\\\\w_\\\\d]+\\\\%.*\",\u00a7not:{\u00a7regex:\".*(\\\\%javabinary\\\\%|\\\\%selftest\\\\%|\\\\%connectpath\\\\%|\\\\%filepath\\\\%|\\\\%fileparentpath\\\\%).*\"}}}", logic=StorableValidationLogic.FAIL_ON_MATCH, description="Unknown %replacer%. Please check for typos", level=FailLevel.WARNING)
    @StorableDoc(value="The commandline. Each parameter should be an array entry.\r\nDo not use cmd /c for *.bat files, but simple [\".%DYNLINK/mybat.bat\",\"param1\"].\r\nExecute Connect-Service packages like an *.exe [\".%DYNLINK/package.zip\"]. Parameters are not allowed for Connect-Service packages.  You can use dynamic link replacer, and further replacers like %fileparentpath%, %filepath% (ClientOptions) and %connectpath%,%selftest%,%javabinary%,%jre%,%jre_w%")
    @StorableExample(value="[\".%MY_APP/install.bat\"]")
    private String[] cmd;
    @StorableDoc(value="Execute only if the conditions resolve to true. The conditions are matched against an instance of ExecuteConditionMatcher. Alternativly, a match against a filepath is possible: {\"\u00a7file\":{\"\u00a7options\":{\"path\":\".%CONNECT\"},\"directory\":true}}")
    @StorableLink(labels={"Matches against ExecuteConditionMatcher", "Supports FileLink"}, hrefs={"https://projects.appwork.org/projects/connect-system-documentation/wiki/ExecuteConditionMatcher", "https://projects.appwork.org/projects/connect-system-documentation/wiki/FileLink"})
    @StorableSee(value={GenericConditionMatcher.class})
    private PreCondition[] conditions;
    @StorableDoc(value="Allowed Execution Modes. The modes are tried one after another, until the process could get started.CONNECT_SERVIVE works only for signed Connect-Service Packages")
    @StorableValidateCondition(value="{\u00a7any:{\u00a7eq:CONNECT_SERVICE},\u00a7parent.cmd[0]:{$not:{\u00a7regex:\"(?i).*\\\\.zip$\"}}}", logic=StorableValidationLogic.FAIL_ON_MATCH, description="If you select CONNECT_SERVICE, you have to launch a zip Connect Service package in the cmd property.")
    @StorableSee(value={ElevationMode.class})
    private ElevationMode[] elevation = new ElevationMode[]{ElevationMode.NONE};
    @StorableDoc(value="A regular expression that is used on each console out line to find the final errormessage.")
    @StorableValidateRegex(message="Must be a valid regular expression with a matcher group", nullAllowed=true)
    @StorableExample(value="\"^error=(.+)\"")
    private String errorPattern;
    @StorableDoc(value="Localized display message to display while the process is executed - might get used in the UI")
    private LocaleMap message;
    @StorableDoc(value="A regular expression that is used on each console out line to find statusmessages")
    @StorableValidateRegex(message="Must be a valid regular expression with a matcher group", nullAllowed=true)
    @StorableExample(value="\"^status=(.+)\"")
    private String messagePattern;
    @StorableDoc(value="Localized display name of the process - might get used in the UI")
    private LocaleMap name;
    @StorableDoc(value="A regular expression that is used on each console out line to find progress numbers")
    @StorableValidateRegex(message="Must be a valid regular expression with a matcher group. The progress musst be in format -1[.0] > 100[.0], while -1 is indeterminated", nullAllowed=true)
    @StorableExample(value="\"^progress=(-?\\\\d+)\"")
    private String progressPattern;
    @StorableDoc(value="Define how Connect has to handle different exitcodes. Connect will evaluate the mappings one after another and trigger the first matching action.*Note:* executionSuccessExitCodeRegex and executionSuccessRegex are evaluated first. If you want to use the mapping only, set them to .*(Accept all)")
    @StorableValidateCondition(level=FailLevel.WARNING, value="{\u00a7or:[{\u00a7ne:null},{\u00a7size:0}]}", description="If null or empty, Connect will continue the installation even if the process fails.\r\nDefine proper resultMapping to trigger an appropriate action instead.")
    private List<ExecuteResultMapping> resultMapping;
    @StorableDoc(value="Timeout in ms. If the process did not return after this timeout, Connect will kill it and show an installation error")
    private TimeSpan timeout = null;
    @StorableDoc(value="The working directory for the process. All relative paths are relative to this property. The default value depends on the context. ClientOptions: the parent of the ClientOption file. Rest: :%CONNECT. You can use dynamic link replacer, and further replacers like %fileparentpath%, %filepath% (ClientOptions) and %connectpath%,%selftest%,%javabinary%,%jre%,%jre_w%.")
    @StorableValidateCondition2(value="{\u00a7eq:\"\"}", logic=StorableValidationLogic.FAIL_ON_MATCH, description="An empty string as working directory \"\" will get resolved to the Connect Installation directory. Use .%CONNECT instead. Use null to use the referenced parent directory (e.g. in ClientOptions).")
    @StorableValidateCondition3(value="{\u00a7regex:\".*\\\\%[\\\\w_\\\\d]+\\\\%.*\",\u00a7not:{\u00a7regex:\".*(\\\\%javabinary\\\\%|\\\\%selftest\\\\%|\\\\%connectpath\\\\%|\\\\%filepath\\\\%|\\\\%jre\\\\%|\\\\%jre_w\\\\%|\\\\%fileparentpath\\\\%).*\"}}", logic=StorableValidationLogic.FAIL_ON_MATCH, description="Unknown %replacer%. Please check for typos", level=FailLevel.WARNING)
    private String workingDirectory;

    public String[] getAllowAccess() {
        return this.allowAccess;
    }

    public String[] getCmd() {
        return this.cmd;
    }

    public PreCondition[] getConditions() {
        return this.conditions;
    }

    public ElevationMode[] getElevation() {
        return this.elevation;
    }

    public String getErrorPattern() {
        return this.errorPattern;
    }

    public LocaleMap getMessage() {
        return this.message;
    }

    public String getMessagePattern() {
        return this.messagePattern;
    }

    public LocaleMap getName() {
        return this.name;
    }

    public String getProgressPattern() {
        return this.progressPattern;
    }

    public List<ExecuteResultMapping> getResultMapping() {
        return this.resultMapping;
    }

    public TimeSpan getTimeout() {
        return this.timeout;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setAllowAccess(String[] allowAccess) {
        this.allowAccess = allowAccess;
    }

    public void setCmd(String[] cmd) {
        this.cmd = cmd;
    }

    public void setConditions(PreCondition[] conditions) {
        this.conditions = conditions;
    }

    public void setElevation(ElevationMode[] modes) {
        this.elevation = modes;
    }

    public void setErrorPattern(String errorPattern) {
        this.errorPattern = errorPattern;
    }

    public void setMessage(LocaleMap message) {
        this.message = message;
    }

    public void setMessagePattern(String messagePattern) {
        this.messagePattern = messagePattern;
    }

    public void setName(LocaleMap name) {
        this.name = name;
    }

    public void setProgressPattern(String progressPattern) {
        this.progressPattern = progressPattern;
    }

    public void setResultMapping(List<ExecuteResultMapping> resultMapping) {
        this.resultMapping = resultMapping;
    }

    public void setTimeout(TimeSpan timeout) {
        this.timeout = timeout;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }
}

