/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import org.appwork.updatesys.transport.exchange.ErrorCode;
import org.appwork.updatesys.transport.exchange.ResponseStatus;
import org.appwork.updatesys.transport.exchange.ServerResponse;
import org.appwork.updatesys.transport.exchange.interfaces.ErrorResponseInterface;
import org.appwork.updatesys.transport.exchange.json.ErrorJsonResponse;

public class ErrorResponse
extends ServerResponse
implements ErrorResponseInterface {
    private final int destRevision;
    private final ErrorCode errorCode;

    @Override
    public int getDestRevision() {
        return this.destRevision;
    }

    @Override
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public ErrorResponse(int destRevision, ErrorCode code) {
        super(ResponseStatus.ERROR);
        this.destRevision = destRevision;
        this.errorCode = code;
    }

    public ErrorResponse(String[] lines) {
        super(ResponseStatus.ERROR);
        this.destRevision = Integer.parseInt(lines[1]);
        this.errorCode = ErrorCode.valueOf(lines[2]);
    }

    @Override
    public Object[] getFields() {
        return new Object[]{this.destRevision, this.errorCode};
    }

    @Override
    public String getRevisionName() {
        return null;
    }

    @Override
    public ErrorJsonResponse toJsonVariant() {
        return new ErrorJsonResponse(this);
    }
}

